<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

class JElementBlogs extends JElement
{
	var	$_name = 'Blogs';

	function fetchElement($name, $value, &$node, $control_name)
	{
		$mainframe	=& JFactory::getApplication();
		$db			=& JFactory::getDBO();
		$doc 		=& JFactory::getDocument();

		require_once( JPATH_ROOT . DS . 'components' . DS . 'com_easyblog' . DS . 'constants.php' );
		require_once( EBLOG_HELPERS . DS  . 'helper.php' );

		JHTML::_( 'behavior.modal' );
		
		$document	= JFactory::getDocument();
		$document->addScript( JURI::root() . 'components/com_easyblog/assets/js/jquery.js' );

		if( $value == '0' )
		{
			$value	= JText::_( 'Select an entry' );
		}
		else
		{
			$blog	= EasyBlogHelper::getTable( 'Blog' );
			$blog->load( $value );
			$value	= $blog->title;
		}
		ob_start();
		?>
<script type="text/javascript">
function insertBlog( id , name )
{
	sQuery( '#item_id' ).val( id );
	sQuery( '#item_value' ).val( name );

	<?php
	if(EasyBlogHelper::getJoomlaVersion() >= '1.6')
	{
	?>
		window.parent.SqueezeBox.close();
	<?php
	}
	else
	{
	?>
		window.parent.document.getElementById('sbox-window').close();
	<?php
	}
	?>
}
</script>
		<div style="float:left;">
			<input type="text" id="item_value" readonly="readonly" value="<?php echo $value; ?>" disabled="disabled" style="background: #ffffff;width: 200px;" />
		</div>
		<div class="button2-left">
			<div class="blank">
				<a rel="{handler: 'iframe', size: {x: 750, y: 475}}" href="<?php echo JRoute::_( 'index.php?option=com_easyblog&view=blogs&tmpl=component&browse=1&browsefunction=insertBlog' );?>" title="Select an Article" class="modal"><?php echo JText::_( 'Select' ); ?></a>
			</div>
		</div>
		<input type="hidden" id="item_id" name="<?php echo $control_name;?>[<?php echo $name;?>]" value="" />
		<?php
		$html	= ob_get_contents();
		ob_end_clean();
		return $html;
	}
}
