<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

/**
 * This file and method will automatically get called by Joomla
 * during the installation process 
 **/

require_once( JPATH_ROOT . DS . 'components' . DS . 'com_easyblog' . DS . 'constants.php' );
require_once( JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_easyblog'.DS.'install.defaultvalue.php' );
require_once( EBLOG_HELPERS . DS . 'helper.php' );

function com_install()
{
	$message	= array();
	$status		= true;
	
	$phpVersion = floatval(phpversion());
	if($phpVersion >= 5)
	{
		//get version number from manifest file.
		$installer	=& JInstaller::getInstance();
		$manifest	=& $installer->getManifest();
		$sourcePath	=& $installer->getPath('source');
		$version	=& $manifest->document->getElementByPath('version');
		
		// fix invalid admin menu id with Joomla 1.7
		fixMenuIds();
		
		//create default easy blog config
		if( !configExist() )
		{
			if(!createConfig())
			{
				$message[] = 'Warning : The system encounter an error when it tries to create default config. Please kindly configure your Easy Blog manually.';
			}
		}
		
		//update Db columns first before proceed.
		updateEasyBlogDBColumns();
		
		//update or create menu item.
		if( menuExist() )
		{
			if(!updateMenuItems())
			{
				$message[] = 'Warning : The system encounter an error when it tries to update the menu item. Please kindly update the menu item manually.';
			}
		}
		else
		{
			if(!createMenuItems())
			{
				$message[] = 'Warning : The system encounter an error when it tries to create a menu item. Please kindly create the menu item manually.';
			}
		}
	
		//check if need to create default category
		if( !blogCategoryExist() )
		{
			if(!createBlogCategory())
			{
				$message[] = 'Warning : The system encounter an error when it tries to create default blog categories. Please kindly create the categories manually.';
			}
		}
		
		//check if need to create sample post
		if( !postExist() )
		{
			if(!createSamplePost())
			{
				$message[] = 'Warning : The system encounter an error when it tries to create some sample post.';
			}
		}
		
		//check if twitter table exist.
		if( twitterTableExist() )
		{
			//migrate twitter data if the table exist
			if(!twitterTableMigrate())
			{
				$message[] = 'Warning : The system encounter an error when it tries to migrate your social share data to a new table. Please kindly migrate the data manually.';
			}
			else
			{
				if(!twitterTableRemove())
				{
					$message[] = 'Warning : The system encounter an error when it tries to remove the unused twitter table. Please kindly remove the table manually.';
				}
			}
		}
		
		//truncate the table before recreating the default acl rules.
		if(!truncateACLTable())
		{
			$message[] = 'Fatal Error : The system encounter an error when it tries to truncate the acl rules table. Please kindly check your database permission and try again.';
			$status = false;
		}
		
		//update acl rules
		if(!updateACLRules())
		{
			$message[] = 'Fatal Error : The system encounter an error when it tries to create the ACL rules. Please kindly check your database permission and try again.';
			$status = false;
		}
		else
		{
			//update user group acl rules
			if(!updateGroupACLRules())
			{
				$message[] = 'Fatal Error : The system encounter an error when it tries to create the user groups ACL rules. Please kindly check your database permission and try again.';
				$status = false;
			}
		}
		
		//install default plugin.
		if(!installDefaultPlugin($sourcePath))
		{
			$message[] = 'Warning : The system encounter an error when it tries to install the user plugin. Please kindly install the plugin manually.';
		}
		
		//copy media files
		if(!copyMediaFiles($sourcePath))
		{
			$message[]	= 'Warning: The system could not copy files to Media folder. Please kindly check the media folder permission.';
			$status		= false;
		}
		
		if($status)
		{
			$message[] = 'Success : Installation Completed. Thank you for choosing Easy Blog.';
		}
	}
	else
	{
		$message[] = 'Fatal Error : Installation was unsuccessful because you are using an unsupported version of PHP. EasyBlog supports only <B>PHP5</B> and above. Please kindly upgrade your PHP version and try again.';
		$status = false;
	}
	
	ob_start();
	?>
	
	<style type="text/css">
	/**
	 * Messages
	 */
	
	#eblog-message {
		color: red;
		font-size:13px;
		margin-bottom: 15px;
		padding: 5px 10px 5px 35px;
	}
	
	#eblog-message.error {
		border-top: solid 2px #900;
		border-bottom: solid 2px #900;
		color: #900;
	}
	
	#eblog-message.info {
		border-top: solid 2px #06c;
		border-bottom: solid 2px #06c;
		color: #06c;
	}
	
	#eblog-message.warning {
		border-top: solid 2px #f90;
		border-bottom: solid 2px #f90;
		color: #c30;
	}
	</style>
		
	<table width="100%" border="0">
		<tr>
			<td>
				<div><img src="http://stackideas.com/images/eblog/install_success3.png" /></div>
			</td>
		</tr>
		<?php
			foreach($message as $msgString)
			{
				$msg = explode(":", $msgString);				
				switch(trim($msg[0]))
				{
					case 'Fatal Error':
						$classname = 'error';
						break;
					case 'Warning':
						$classname = 'warning';
						break;
					case 'Success':
					default:
						$classname = 'info';
						break;
				}
				?>
				<tr>
					<td><div id="eblog-message" class="<?php echo $classname; ?>"><?php echo $msg[0] . ' : ' . $msg[1]; ?></div></td>
				</tr>
				
				<tr>
					<td><h3>Need help in starting up? Check out our <a href="http://stackideas.com/docs/easyblog.html" target="_blank">Documentations</a>.</h3></td>
				</tr>
				<?php
			}
		?>
	</table>
	<?php
	$html = ob_get_contents();
	@ob_end_clean();

	echo $html;
	
	return $status;
}