<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');
?>
<script type="text/javascript">
sQuery(function(){
	sQuery( '#truncateType' ).bind( 'change' , function(){
		if( sQuery( this ).val() == 'chars' || sQuery( this ).val() == 'words' )
		{
			sQuery( '#maxchars' ).show();
			sQuery( '#maxtag' ).hide();
		}
		else
		{
			sQuery( '#maxtag' ).show();
			sQuery( '#maxchars' ).hide();
		}
	});
});
</script>
<table cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<td valign="top" width="50%">
			<table class="noshow">
				<tr>
					<td width="50%" valign="top">
						<a name="main_config" id="main_config"></a>
						<fieldset class="adminform">
						<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_GENERAL_TITLE' ); ?></legend>
						<table class="admintable" cellspacing="1">
							<tbody>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_BLOG_TITLE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_BLOG_TITLE_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_BLOG_TITLE' ); ?>
								</span>
								</td>
								<td valign="top">
									<input type="text" name="main_title" class="inputbox full-width" value="<?php echo $this->config->get('main_title');?>" />
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_BLOG_DESCRIPTION' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_BLOG_DESCRIPTION_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_BLOG_DESCRIPTION' ); ?>
								</span>
								</td>
								<td valign="top">
									<textarea name="main_description" rows="5" class="inputbox  full-width textarea" cols="35"><?php echo $this->config->get('main_description');?></textarea>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ORPHANED_ITEMS_OWNER' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ORPHANED_ITEMS_OWNER_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ORPHANED_ITEMS_OWNER' ); ?>
								</span>
								</td>
								<td valign="top">
									<input type="text" name="main_orphanitem_ownership" class="inputbox" style="width: 50px;" value="<?php echo $this->config->get('main_orphanitem_ownership', $this->defaultSAId );?>" />
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_JOOMLA_USER_PARAMETERS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_JOOMLA_USER_PARAMETERS_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_JOOMLA_USER_PARAMETERS' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_joomlauserparams' , $this->config->get( 'main_joomlauserparams' , true ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_EDIT_ACCOUNT' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_EDIT_ACCOUNT_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_EDIT_ACCOUNT' ); ?>
									</span>
								</td>
								<td valign="top">
									<?php echo $this->renderCheckbox( 'main_dashboard_editaccount' , $this->config->get( 'main_dashboard_editaccount' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_TRACKBACKS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_TRACKBACKS_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_TRACKBACKS' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_trackbacks' , $this->config->get( 'main_trackbacks' , true ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_PASSWORD_PROTECTION' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_PASSWORD_PROTECTION_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_PASSWORD_PROTECTION' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_password_protect' , $this->config->get( 'main_password_protect' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_AUTOMATIC_FEATURE_BLOG_POST' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_AUTOMATIC_FEATURE_BLOG_POST_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_AUTOMATIC_FEATURE_BLOG_POST' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_autofeatured' , $this->config->get( 'main_autofeatured' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_REQUIRE_LOGIN_TO_READ_FULL' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_REQUIRE_LOGIN_TO_READ_FULL_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_REQUIRE_LOGIN_TO_READ_FULL' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_login_read' , $this->config->get( 'main_login_read' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_HIDE_INTROTEXT_IN_ENTRY' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_HIDE_INTROTEXT_IN_ENTRY_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_HIDE_INTROTEXT_IN_ENTRY' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_hideintro_entryview' , $this->config->get( 'main_hideintro_entryview' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_HIDE_EMPTY_CATEGORIES' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_HIDE_EMPTY_CATEGORIES_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_HIDE_EMPTY_CATEGORIES' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_categories_hideempty' , $this->config->get( 'main_categories_hideempty' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_TEAMBLOG_INCLUDE_TEAMBLOG_POSTS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_TEAMBLOG_INCLUDE_TEAMBLOG_POSTS_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_TEAMBLOG_INCLUDE_TEAMBLOG_POSTS' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_includeteamblogpost' , $this->config->get( 'main_includeteamblogpost' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_EXCLUDE_USERS_FROM_BLOGGER_LISTINGS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_LAYOUT_EXCLUDE_USERS_FROM_BLOGGER_LISTINGS_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_EXCLUDE_USERS_FROM_BLOGGER_LISTINGS' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<input type="text" name="layout_exclude_bloggers" class="inputbox" style="width: 300px;" value="<?php echo $this->config->get( 'layout_exclude_bloggers' );?>" />
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_EXCLUDE_CATEGORIES_FROM_FRONTPAGE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_LAYOUT_EXCLUDE_CATEGORIES_FROM_FRONTPAGE_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_EXCLUDE_CATEGORIES_FROM_FRONTPAGE' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<input type="text" name="layout_exclude_categories" class="inputbox" style="width: 300px;" value="<?php echo $this->config->get( 'layout_exclude_categories' );?>" />
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_NEW_ENTRY_ON_FRONTPAGE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_NEW_ENTRY_ON_FRONTPAGE_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_NEW_ENTRY_ON_FRONTPAGE' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
								<?php
			  						$frontpageFormat = array();
									$frontpageFormat[] = JHTML::_('select.option', '0', JText::_( 'COM_EASYBLOG_NO_OPTION' ) );
									$frontpageFormat[] = JHTML::_('select.option', '1', JText::_( 'COM_EASYBLOG_YES_OPTION' ) );
									echo JHTML::_('select.genericlist', $frontpageFormat, 'main_newblogonfrontpage', 'size="1" class="inputbox"', 'value', 'text', $this->config->get('main_newblogonfrontpage' ) );
								?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DEFAULT_BLOG_PRIVACY' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_DEFAULT_BLOG_PRIVACY_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DEFAULT_BLOG_PRIVACY' ); ?>
								</span>
								</td>
								<td valign="top">
								<?php
			  						$nameFormat = array();
									$nameFormat[] = JHTML::_('select.option', '0', JText::_( 'COM_EASYBLOG_PUBLIC_OPTION' ) );
									$nameFormat[] = JHTML::_('select.option', '1', JText::_( 'COM_EASYBLOG_PRIVATE_OPTION' ) );
									$showdet = JHTML::_('select.genericlist', $nameFormat, 'main_blogprivacy', 'size="1" class="inputbox"', 'value', 'text', $this->config->get('main_blogprivacy' ) );
									echo $showdet;
								?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_BLOGGER_TO_SWITCH' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_BLOGGER_TO_SWITCH_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_BLOGGER_TO_SWITCH' ); ?>
								</span>
								</td>
								<td valign="top">
									<?php echo $this->renderCheckbox( 'main_blogprivacy_override' , $this->config->get( 'main_blogprivacy_override' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DEFAULT_BLOG_PUBLISHING_STATUS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_DEFAULT_BLOG_PUBLISHING_STATUS_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DEFAULT_BLOG_PUBLISHING_STATUS' ); ?>
								</span>
								</td>
								<td valign="top">
								<?php
			  						$publishFormat = array();
									$publishFormat[] = JHTML::_('select.option', '0', JText::_( 'COM_EASYBLOG_UNPUBLISHED_OPTION' ) );
									$publishFormat[] = JHTML::_('select.option', '1', JText::_( 'COM_EASYBLOG_PUBLISHED_OPTION' ) );
									$publishFormat[] = JHTML::_('select.option', '2', JText::_( 'COM_EASYBLOG_SCHEDULED_OPTION' ) );
									$publishFormat[] = JHTML::_('select.option', '3', JText::_( 'COM_EASYBLOG_DRAFT_OPTION' ) );

									$showdet = JHTML::_('select.genericlist', $publishFormat, 'main_blogpublishing', 'size="1" class="inputbox"', 'value', 'text', $this->config->get('main_blogpublishing' , '1' ) );
									echo $showdet;
								?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DAYLIGHT_SAVING_TIME' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_DAYLIGHT_SAVING_TIME_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DAYLIGHT_SAVING_TIME' ); ?>
								</span>
								</td>
								<td valign="top">
									<?php echo $this->dstList; ?>
								</td>
							</tr>
							
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DISPLAY_NON_BLOGGER_PROFILE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_DISPLAY_NON_BLOGGER_PROFILE_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DISPLAY_NON_BLOGGER_PROFILE' ); ?>
								</span>
								</td>
								<td valign="top">
									<?php echo $this->renderCheckbox( 'main_nonblogger_profile' , $this->config->get( 'main_nonblogger_profile' ) );?>
								</td>
							</tr>
							
							</tbody>
						</table>
						</fieldset>
					</td>
				</tr>
			</table>
		</td>
		<td valign="top">
			<table class="noshow">
				<tr>
					<td>
						<fieldset class="adminform">
						<legend><?php echo JText::_( 'Frontpage Blog truncation' ); ?></legend>
						<table class="admintable" cellpadding="1">
						<tbody>
						<tr>
							<td class="key">
							<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_TRUNCATE_BLOG_CONTENT_AS_INTROTEXT' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_LAYOUT_TRUNCATE_BLOG_CONTENT_AS_INTROTEXT_DESC'); ?>">
								<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_TRUNCATE_BLOG_CONTENT_AS_INTROTEXT' ); ?>
							</span>
							</td>
							<td valign="top">
								<?php echo $this->renderCheckbox( 'layout_blogasintrotext' , $this->config->get( 'layout_blogasintrotext' ) );?>
							</td>
						</tr>
						<tr>
							<td class="key">
							<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_TRUNCATE_BLOG_TYPE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_LAYOUT_TRUNCATE_BLOG_TYPE_DESC'); ?>">
								<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_TRUNCATE_BLOG_TYPE' ); ?>
							</span>
							</td>
							<td valign="top">
								<select name="main_truncate_type" class="inputbox" id="truncateType">
									<option value="chars"<?php echo $this->config->get( 'main_truncate_type' ) == 'chars' ? ' selected="selected"':'';?>><?php echo JText::_( 'COM_EASYBLOG_BY_CHARACTERS' ); ?></option>
									<option value="words"<?php echo $this->config->get( 'main_truncate_type' ) == 'words' ? ' selected="selected"':'';?>><?php echo JText::_( 'COM_EASYBLOG_BY_WORDS' ); ?></option>
									<option value="paragraph"<?php echo $this->config->get( 'main_truncate_type' ) == 'paragraph' ? ' selected="selected"':'';?>><?php echo JText::_( 'COM_EASYBLOG_BY_PARAGRAPH' ); ?></option>
									<option value="break"<?php echo $this->config->get( 'main_truncate_type' ) == 'break' ? ' selected="selected"':'';?>><?php echo JText::_( 'COM_EASYBLOG_BY_BREAK' );?></option>
								</select>
							</td>
						</tr>
						<tr id="maxchars" style="<?php echo ($this->config->get( 'main_truncate_type' ) == 'chars' || $this->config->get( 'main_truncate_type' ) == 'words') ? '' : 'display:none;';?>">
							<td class="key">
							<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_MAX_LENGTH_OF_BLOG_CONTENT_AS_INTROTEXT' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_LAYOUT_MAX_LENGTH_OF_BLOG_CONTENT_AS_INTROTEXT_DESC'); ?>">
								<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_MAX_LENGTH_OF_BLOG_CONTENT_AS_INTROTEXT' ); ?>
							</span>
							</td>
							<td valign="top">
								<input type="text" name="layout_maxlengthasintrotext" class="inputbox" style="width: 50px;" value="<?php echo $this->config->get('layout_maxlengthasintrotext' , '150' );?>" />
							</td>
						</tr>
						<tr id="maxtag" style="<?php echo ($this->config->get( 'main_truncate_type' ) == 'break' || $this->config->get( 'main_truncate_type' ) == 'paragraph') ? '' : 'display:none;';?>">
							<td class="key">
							<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_MAX_LENGTH_TAGS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_LAYOUT_MAX_LENGTH_TAGS_DESC'); ?>">
								<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_LAYOUT_MAX_LENGTH_TAGS' ); ?>
							</span>
							</td>
							<td valign="top">
								<input type="text" name="main_truncate_maxtag" class="inputbox" style="width: 50px;" value="<?php echo $this->config->get('main_truncate_maxtag');?>" />
							</td>
						</tr>
						</tbody>
						</table>
						</fieldset>
						<fieldset class="adminform">
						<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_RATINGS_TITLE' ); ?></legend>
						<table class="admintable" cellspacing="1">
							<tbody>
							<tr>
								<td width="300" class="key">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_RATINGS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_RATINGS_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_RATINGS' ); ?>
									</span>
								</td>
								<td class="value">
									<?php echo $this->renderCheckbox( 'main_ratings' , $this->config->get( 'main_ratings' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_RATINGS_FRONTPAGE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_RATINGS_FRONTPAGE_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_RATINGS_FRONTPAGE' ); ?>
									</span>
								</td>
								<td class="value">
									<?php echo $this->renderCheckbox( 'main_ratings_frontpage' , $this->config->get( 'main_ratings_frontpage' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_LOCKED_ON_FRONTPAGE' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_LOCKED_ON_FRONTPAGE_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_LOCKED_ON_FRONTPAGE' ); ?>
									</span>
								</td>
								<td class="value">
									<?php echo $this->renderCheckbox( 'main_ratings_frontpage_locked' , $this->config->get( 'main_ratings_frontpage_locked' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_GUEST_RATING' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_GUEST_RATING_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ALLOW_GUEST_RATING' ); ?>
									</span>
								</td>
								<td class="value">
									<?php echo $this->renderCheckbox( 'main_ratings_guests' , $this->config->get( 'main_ratings_guests' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DISPLAY_PEOPLE_RATED' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_DISPLAY_PEOPLE_RATED_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_DISPLAY_PEOPLE_RATED' ); ?>
									</span>
								</td>
								<td class="value">
									<?php echo $this->renderCheckbox( 'main_ratings_display_raters' , $this->config->get( 'main_ratings_display_raters' ) );?>
								</td>
							</tr>
							</tbody>
						</table>
						</fieldset>
					</td>
				</tr>
				<tr>
					<td>
						<fieldset class="adminform">
						<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_AUTODRAFTING_TITLE' ); ?></legend>
						<table class="admintable" cellspacing="1">
							<tbody>
							<tr>
								<td width="300" class="key">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_AUTODRAFTING' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_AUTODRAFTING_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_AUTODRAFTING' ); ?>
									</span>
								</td>
								<td class="value">
									<?php echo $this->renderCheckbox( 'main_autodraft' , $this->config->get( 'main_autodraft' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_AUTODRAFTING_INTERVAL' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_AUTODRAFTING_INTERVAL_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_AUTODRAFTING_INTERVAL' ); ?>
									</span>
								</td>
								<td class="value">
									<input type="text" name="main_autodraft_interval" class="inputbox" style="width: 30px;text-align: center;" value="<?php echo $this->config->get('main_autodraft_interval', '0' );?>" />
									<?php echo JText::_( 'COM_EASYBLOG_SECONDS' );?>
								</td>
							</tr>
							</tbody>
						</table>
						</fieldset>
					</td>
				</tr>
				<tr>
					<td>
						<fieldset class="adminform">
						<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ERROR_LOGGING' ); ?></legend>
						<p class="small"><?php echo JText::_( 'COM_EASYBLOG_ERROR_LOGS_TIPS' ); ?></p>
						<table class="admintable" cellspacing="1">
							<tbody>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ERROR_LOGGING_SEND' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ERROR_LOGGING_SEND_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ERROR_LOGGING_SEND' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_error_logging' , $this->config->get( 'main_error_logging' ) );?>
								</td>
							</tr>
							<!-- tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_DEBUG' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_DEBUG_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_DEBUG' ); ?>
								</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'debug_javascript' , $this->config->get( 'debug_javascript' ) );?>
								</td>
							</tr -->
							</tbody>
						</table>
						</fieldset>
					</td>
				</tr>
				<tr>
					<td>
						<fieldset class="adminform">
						<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_TEASER' ); ?></legend>
						<table class="admintable" cellspacing="1">
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_USE_FIRST_IMAGE_AS_TEASER' ); ?>::<?php echo JText::_('COM_EASYBLOG_USE_FIRST_IMAGE_AS_TEASER_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_USE_FIRST_IMAGE_AS_TEASER' ); ?>
								</span>
								</td>
								<td valign="top">
									<?php echo $this->renderCheckbox( 'main_teaser_image' , $this->config->get( 'main_teaser_image' ) );?>
								</td>
							</tr>
							<tr>
								<td width="300" class="key">
								<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_TEASER_IMAGE_ALIGNMENT' ); ?>::<?php echo JText::_('COM_EASYBLOG_TEASER_IMAGE_ALIGNMENT_DESC'); ?>">
									<?php echo JText::_( 'COM_EASYBLOG_TEASER_IMAGE_ALIGNMENT' ); ?>
								</span>
								</td>
								<td valign="top">
									<select name="main_teaser_image_align" class="inputbox">
										<option value="float-l"<?php echo $this->config->get( 'main_teaser_image_align' ) == 'float-l' ? ' selected="selected"' : '';?>><?php echo JText::_( 'COM_EASYBLOG_WRAPPED_LEFT' ); ?></option>
										<option value="float-r"<?php echo $this->config->get( 'main_teaser_image_align' ) == 'float-r' ? ' selected="selected"' : '';?>><?php echo JText::_( 'COM_EASYBLOG_WRAPPED_RIGHT'); ?></option>
										<option value="left"<?php echo $this->config->get( 'main_teaser_image_align' ) == 'left' ? ' selected="selected"' : '';?>><?php echo JText::_( 'COM_EASYBLOG_LEFT' ); ?></option>
										<option value="center"<?php echo $this->config->get( 'main_teaser_image_align' ) == 'center' ? ' selected="selected"' : '';?>><?php echo JText::_( 'COM_EASYBLOG_CENTER' ); ?></option>
										<option value="right"<?php echo $this->config->get( 'main_teaser_image_align' ) == 'right' ? ' selected="selected"' : '';?>><?php echo JText::_( 'COM_EASYBLOG_RIGHT' ); ?></option>
									</select>
								</td>
							</tr>
						</table>
						</fieldset>
					</td>
				</tr>

				<tr>
					<td>
						<fieldset class="adminform">
						<legend><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_RSS' ); ?></legend>
						<table class="admintable" cellspacing="1">
							<tr>
								<td class="key" width="300">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_RSS' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_RSS_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_ENABLE_RSS' ); ?>
									</span>
								</td>
								<td valign="top" class="value">
									<?php echo $this->renderCheckbox( 'main_rss' , $this->config->get( 'main_rss' ) );?>
								</td>
							</tr>
							<tr>
								<td class="key" width="300">
									<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_RSS_CONTENT' ); ?>::<?php echo JText::_('COM_EASYBLOG_SETTINGS_WORKFLOW_RSS_CONTENT_DESC'); ?>">
										<?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_RSS_CONTENT' ); ?>
									</span>
								</td>
								<td valign="top" class="value">
									<select name="main_rss_content" class="inputbox">
										<option value="introtext"<?php echo $this->config->get( 'main_rss_content' ) == 'introtext' ? ' selected="selected"' : '';?>><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_RSS_CONTENT_INTROTEXT' ); ?></option>
										<option value="fulltext"<?php echo $this->config->get( 'main_rss_content' ) == 'fulltext' ? ' selected="selected"' : '';?>><?php echo JText::_( 'COM_EASYBLOG_SETTINGS_WORKFLOW_RSS_CONTENT_FULLTEXT' ); ?></option>
									</select>
								</td>
							</tr>
						</table>
						</fieldset>
					</td>
				</tr>

			</table>
		</td>
	</tr>
</table>
