<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

class EasyBlogViewUpdater extends JView 
{
	function display($tpl = null)
	{
		//initialise variables
		$document	=& JFactory::getDocument();
		$user		=& JFactory::getUser();
		$mainframe	=& JFactory::getApplication();
		
		$curl		= function_exists( 'curl_multi_init' );

		$this->assign( 'curl' , $curl );
		parent::display($tpl);
	}

	function getInstalledVersion()
	{
		static $version	= false;
		
		if( !$version )
		{
			$version		= EasyBlogHelper::getLocalVersion();
		}
		
		return $version;
	}

	function getLatestVersion()
	{
		static $version	= false;
		
		if( !$version )
		{
			$version	= EasyBlogHelper::getVersion();
		}

		return $version;
	}
	
	function registerToolbar()
	{
		JToolBarHelper::title( JText::_( 'COM_EASYBLOG_UPDATER' ), 'updater' );

		JToolBarHelper::back( 'Home' , 'index.php?option=com_easyblog');
	}
}