<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.application.component.controller' );

class SimpleMETAManagementController_categories extends JController {
	function __construct( $default = array())
	{
		parent::__construct( $default );
	}

	function cancel()
	{
		$this->setRedirect( 'index.php?option=com_smms&view=categories' );
	}

	function backcpanel()
	{
		$this->setRedirect( 'index.php?option=com_smms' );
	}
	
	function apply()
	{
		SimpleMETAManagementController_categories::save(true);
	}

	function save($apply = false)
	{
		global $mainframe;

		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db							=& JFactory::getDBO();
		$cid						= JRequest::getVar( 'cid', array(0), '', 'array' );
		JArrayHelper::toInteger($cid, array(0));
		$id							= JRequest::getVar( 'id', $cid[0], '', 'int' );
		$option						= JRequest::getVar( 'option' );
		$return						= JRequest::getVar( 'returntask', '', 'post' );
		$addrecord					= JRequest::getVar( 'add', '', 'post', 'int' );
		$form_categoryname			= JRequest::getVar( 'name', '', 'post', 'string', JREQUEST_ALLOWRAW );
		$form_categoriesenabled		= JRequest::getVar( 'enabled', '', 'post' );
		$form_category				= JRequest::getVar( 'category', '', 'post', 'string', JREQUEST_ALLOWRAW  );
		
		$form_categoryname			= SimpleMETAManagementFunctions_common::sterilisetext($form_categoryname);
		$form_category				= SimpleMETAManagementFunctions_common::sterilisetext($form_category);
		
		JArrayHelper::toInteger($cid);

		if (count($cid) < 1) {
			$msg =  JText::_('SMMS_CATEGORIES_MESSAGE_EMPTY');
			$mainframe->redirect('index.php?option=' . $option . '&view=categories', $msg, 'error');
		}
		
		if ($addrecord) {
			$query = 'INSERT INTO #__smms_categories (name, enabled, category) VALUES (\''. $form_categoryname .'\',\'' . $form_categoriesenabled . '\',\'' . $form_category . '\')';
			$db->setQuery($query);
			if (!$db->query()) {
				JError::raiseError( 500, $db->stderr() );
				return false;
			}
		} else {
			if ($form_categoriesenabled)
				$query = 'UPDATE #__smms_categories SET enabled = \'' . $form_categoriesenabled . '\', name = \'' . $form_categoryname . '\', category = \'' . $form_category . '\' WHERE id = \''. $id .'\'';
			else
				$query = 'UPDATE #__smms_categories SET enabled = \'' . $form_categoriesenabled . '\', name = \'' . $form_categoryname . '\' WHERE id = \''. $id .'\'';
			$db->setQuery($query);
			if (!$db->query()) {
				JError::raiseError( 500, $db->stderr() );
				return false;
			}
		}
		
		$cache = & JFactory::getCache('com_smms');
		$cache->clean();

		if ($addrecord) {
				$msg = JText::_('SMMS_CATEGORIES_MESSAGE_CATEGORYADDED');
				$mainframe->redirect('index.php?option=' . $option . '&view=categories', $msg);
		} else {
			if ($apply) {
				$msg = JText::_('SMMS_CATEGORIES_MESSAGE_CATEGORYSAVED');
				$mainframe->redirect('index.php?option=' . $option . '&view=categories&task=edit&cid[]='.$id, $msg);
			} else {
				$msg = JText::_('SMMS_CATEGORIES_MESSAGE_CATEGORYSAVED');
				$mainframe->redirect('index.php?option=' . $option . '&view=categories', $msg);
			}
		}
	}
	
	function remove() {
		global $mainframe;
		
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db			=& JFactory::getDBO();
		$cid		= JRequest::getVar( 'cid', array(), 'post', 'array' );
		$option		= JRequest::getCmd( 'option' );
		$return		= JRequest::getCmd( 'returntask', '', 'post' );

		JArrayHelper::toInteger($cid);

		if (count($cid) < 1) {
			$msg =  JText::_('SMMS_CATEGORIES_MESSAGE_EMPTY');
			$mainframe->redirect('index.php?&option='.$option.'&view=categories', $msg, 'error');
		}

		$cids = implode(',', $cid);

		$query = 'DELETE FROM #__smms_categories' .
				' WHERE id IN ( '. $cids. ' )';
		$db->setQuery($query);
		if (!$db->query())
		{
			JError::raiseError( 500, $db->getErrorMsg() );
			return false;
		}

		$cache = & JFactory::getCache('com_smms');
		$cache->clean();

		$msg = JText::_('SMMS_CATEGORIES_MESSAGE_CATEGORYDELETED');
		$mainframe->redirect('index.php?option='.$option.'&view=categories&task='.$return, $msg);
	}

	function edit() {
		global $mainframe;

		$model 			=& JModel::getInstance( 'SimpleMETAManagementModel' );
		$db				=& JFactory::getDBO();
		$user			=& JFactory::getUser();
		$document 		=& JFactory::getDocument();
		$settings 		=& SMMSModelSettings::getInstance();
		$cid			= JRequest::getVar( 'cid', array(0), '', 'array' );
		//$cids 		= implode(',', $cid);
		JArrayHelper::toInteger($cid, array(0));
		$id				= JRequest::getVar( 'id', $cid[0], '', 'int' );
		$option			= JRequest::getCmd( 'option' );

		if (count($cid) < 1) {
			$msg = JText::_('SMMS_CATEGORIES_MESSAGE_CATEGORYEEMPTY');
			$mainframe->redirect('index.php?option='.$option.'&view=categories', $msg, 'error');
		}
				
		$query = 'SELECT  a.id AS id, a.name AS name'
		. ', a.enabled AS enabled, a.category AS category'
		. ' FROM #__smms_categories AS a'
		//. ' WHERE a.id IN (' . $cids . ')'
		. ' WHERE a.id = ' . $id
		. ' ORDER BY a.name asc,a.id '
		;
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		if ($db->getErrorNum()) {
			echo $db->stderr();
			return;
		}
	
		$view = new SimpleMETAManagementView();
		$view->setModel( $model, true );
		$view->edit($rows, $lists);
	}
	
	function display() {
		global $mainframe;
		
		$model 							=& JModel::getInstance( 'SimpleMETAManagementModel' );
		$table 							=& $model->getTable();
		$db								=& JFactory::getDBO();
		$settings 						=& SMMSModelSettings::getInstance();
		$filter_categories_order		= $mainframe->getUserStateFromRequest( $option.'.filter_categories_order',	'filter_categories_order',	'a.name', 'cmd' );
		$filter_categories_order_Dir	= $mainframe->getUserStateFromRequest( $option.'.filter_categories_order_Dir',	'filter_categories_order_Dir',	'asc',	'word' );
		$search							= $mainframe->getUserStateFromRequest( $option.'.search', 'search',	'',	'string' );
		$search							= JString::strtolower( $search );
		$limit							= $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
		$limitstart						= $mainframe->getUserStateFromRequest( $option.'.limitstart', 'limitstart', 0, 'int' );
		$order 							= ' ORDER BY '. $filter_categories_order .' '. $filter_categories_order_Dir. ', a.name, a.id';
		if ($search)
		{
			$filter 		.= ' WHERE LOWER(a.name) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
		}
		$query 				= 'SELECT COUNT(*) FROM #__smms_categories';
		$db->setQuery( $query );
		$total = $db->loadResult();
	
		jimport('joomla.html.pagination');
		$pageNav = new JPagination( $total, $limitstart, $limit );
		$query = 'SELECT  a.id AS id, a.name AS name'
		. ', a.enabled AS enabled, a.category AS category'
		. ' FROM #__smms_categories AS a'
		. $filter
		. ' GROUP BY a.name'
		. $order
		;
		$db->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		$rows = $db->loadObjectList();
		if ($db->getErrorNum())
		{
			echo $db->stderr();
			return;
		}

		$lists['order_categories_Dir'] 	= $filter_categories_order_Dir;
		$lists['order_categories']		= $filter_categories_order;
		$lists['search']				= $search;

		$view = new SimpleMETAManagementView();
		$view->setModel( $model, true );
		$view->display($rows, $pageNav, $lists);
	}

	function add() {
		global $mainframe;

		$model 			=& JModel::getInstance( 'SimpleMETAManagementModel' );
		$db				=& JFactory::getDBO();
		$user			=& JFactory::getUser();
		$document 		=& JFactory::getDocument();
		$settings 		=& SMMSModelSettings::getInstance();	
		
		$view = new SimpleMETAManagementView();
		$view->setModel( $model, true );
		$view->add($rows, $lists);
	}
}

?>