<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.application.component.controller' );

require_once(JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_smms' . DS . 'functions' . DS . 'smms_installer.php');
require_once(JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_smms' . DS . 'tables' . DS . 'smmsextension.php');

class SimpleMETAManagementController_extensions extends JController {

	function __construct( $default = array()) {
		parent::__construct( $default );
	}

	function backcpanel() {
		$this->setRedirect( 'index.php?option=com_smms' );
	}

	function uninstallExtension() {
		global $mainframe;

		$extensionid	= JRequest::getCmd( 'extensionid', 0 );

		// Get an installer instance
		$installer =& JInstaller::getInstance();
		$SMMSInstaller = new SMMSInstaller($installer);
		$installer->setAdapter('smms_ext',$SMMSInstaller);
		$result = false;
		if ($extensionid) {
			$result = $installer->uninstall('smms_ext', $extensionid );
		}

		if (!$result) {
			$msg = JText::_('SMMS_EXTENSIONS_MESSAGE_UNINSTALLATIONSUCCESS');
        } else {
			echo $installer->getError();
			$msg = JText::_('SMMS_EXTENSIONS_MESSAGE_UNINSTALLATIONFAILED');
		}
		$mainframe->redirect('index.php?option=com_smms&view=extensions', $msg);

	}
	
	function install() {
		global $mainframe;
		
		$lang =& JFactory::getLanguage();
		$lang->load('com_installer', JPATH_ADMINISTRATOR);

		$installerModel = new InstallerModelInstall;

		// Get an installer instance
		$installer =& JInstaller::getInstance();

		$SMMSInstaller = new SMMSInstaller($installer);

		/* Fix for a small bug on Joomla on PHP 4 */
		if (version_compare(PHP_VERSION, '5.0.0', '<')) {
			// We use eval to avoid PHP warnings on PHP>=5 versions
            eval("\$installer->setAdapter('smms_ext',&\$SMMSInstaller);");
        }else {
            $installer->setAdapter('smms_ext', $SMMSInstaller);
        }

		$SMMSInstaller->parent = &$installer;
		$install->_adapters['smms_ext'] = &$SMMSInstaller;
		/* End of the fix for PHP <= 4 */

        if ($installerModel->install()) {
			$msg = JText::_('SMMS_EXTENSIONS_MESSAGE_INSTALLATIONSUCCESS');
        } else {
			$msg = JText::_('SMMS_EXTENSIONS_MESSAGE_INSTALLATIONFAILED');
		}
		$mainframe->redirect('index.php?option=com_smms&view=extensions', $msg);
	}

	function changeExtensionState() {
		global $mainframe;

		$model 			=& JModel::getInstance( 'SimpleMETAManagementModel' );
		$db				=& JFactory::getDBO();
		$user			=& JFactory::getUser();
		$document 		=& JFactory::getDocument();
		$settings 		=& SMMSModelSettings::getInstance();
		
		$option			= JRequest::getCmd( 'option', 'com_smms' );
		$extensionid	= JRequest::getCmd( 'extensionid', 0 );
		
		if (!$extensionid) {
			$msg = JText::_('SMMS_EXTENSIONS_MESSAGE_IDEMPTY');
			$mainframe->redirect('index.php?option=' . $option . '&view=extensions', $msg, 'error');
		}
		
		$query	= 'SELECT enabled FROM #__smms_modules WHERE id = \'' . $extensionid .'\'';		
		$db->setQuery($query);
		$extension_enabled 	= $db->loadResult();

		$extensionenabled = ($extension_enabled ? 0 : 1);
		
		$query	= 'UPDATE #__smms_modules SET enabled = \'' . $extensionenabled . '\' WHERE id = \'' . $extensionid . '\'';
		$db->setQuery($query);
		if (!$db->query()) {
			JError::raiseError( 500, $db->stderr() );
			return false;
		}
		
		if ($extensionenabled)
			$msg = JText::_('SMMS_EXTENSIONS_MESSAGE_EXTENSIONENABLED');
		else
			$msg = JText::_('SMMS_EXTENSIONS_MESSAGE_EXTENSIONDISABLED');
		$mainframe->redirect('index.php?option=' . $option . '&view=extensions', $msg);
	}
	
	function display() {
		global $mainframe;

		$model 			=& JModel::getInstance( 'SimpleMETAManagementModel' );
		$db				=& JFactory::getDBO();
		$user			=& JFactory::getUser();
		$document 		=& JFactory::getDocument();
		$settings 		=& SMMSModelSettings::getInstance();
		
		$option			= JRequest::getCmd( 'option', 'com_smms' );

		$rows = '';
		$xmlfile = '';
	
		SimpleMETAManagementFunctions_extensions::loadInstalledExtensions($rows, $xmlfile);
		
		$view = new SimpleMETAManagementView();
		$view->setModel( $model, true );
		$view->display($rows, $lists, $xmlfile);
	}

	function initialinstallation() {
		$jconfig 		= new JConfig();
		$modulename 	= $jconfig->dbprefix . 'smms_modules';
		$db				= &JFactory::getDBO();
		$model 			=& JModel::getInstance( 'SimpleMETAManagementModel' );
	
		$dirname		= JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'extensions' . DS;
		$xmlfiles 		= glob($dirname . "*.xml");
		
		foreach ($xmlfiles as $xmlfile) {      
			unset($ename);
			unset($id);
			
			$ename = str_replace($dirname, '', $xmlfile);
			$ename = str_replace('ext_', '', $ename);
			$ename = str_replace('ext.', '', $ename);
			$ename = str_replace('.xml', '', $ename);

			$query = 'SELECT ' . $db->nameQuote('id') .
					 ' FROM ' . $db->nameQuote('#__smms_modules') .
					 ' WHERE name = ' . $db->Quote($ename);
			$db->setQuery($query);
			if (!$db->Query()) {
				JError::raiseError( 500, JText::_('SMMS_GLOBAL_ERROR_EXTENSIONINSTALL') . $db->stderr(true));
				return false;
			}
			$id = $db->loadResult();

			if (!$id) {
				if (file_exists( $xmlfile )) {
					unset($xml);
					$xml =& JFactory::getXMLParser('simple');
					$xml->loadFile( $xmlfile );
				
					$x_category 				=& $xml->document->getElementByPath('smms_install/database/category');
					$x_databasename 			=& $xml->document->getElementByPath('smms_install/database/databasename');
					$x_pregmatch 				=& $xml->document->getElementByPath('smms_install/database/pregmatch');
					$x_pregmatch2 				=& $xml->document->getElementByPath('smms_install/database/pregmatch2');
					$x_html		 				=& $xml->document->getElementByPath('smms_install/database/html');
					$x_formfield 				=& $xml->document->getElementByPath('smms_install/database/formfield');
					$x_databasefield			=& $xml->document->getElementByPath('smms_install/database/databasefield');
					$x_sqlselect 				=& $xml->document->getElementByPath('smms_install/database/sqlselect');
					$x_sqljoin	 				=& $xml->document->getElementByPath('smms_install/database/sqljoin');
					$x_sqlupdatewithvalue		=& $xml->document->getElementByPath('smms_install/database/sqlupdatewithvalue');
					$x_sqlupdatenovalue			=& $xml->document->getElementByPath('smms_install/database/sqlupdatenovalue');
					
					$row 						= new SMMSExtension($db, $id);
					
					$row->name 					= $ename;
					$row->enabled 				= 0;
					$row->category 				= $x_category->data();
					$row->databasename 			= $x_databasename->data();
					$row->pregmatch 			= $x_pregmatch->data();
					$row->pregmatch2 			= $x_pregmatch2->data();
					$row->html		 			= $x_html->data();
					$row->formfield 			= $x_formfield->data();
					$row->databasefield			= $x_databasefield->data();
					$row->sqlselect 			= $x_sqlselect->data();
					$row->sqljoin	 			= $x_sqljoin->data();
					$row->sqlupdatewithvalue	= $x_sqlupdatewithvalue->data();
					$row->sqlupdatenovalue		= $x_sqlupdatenovalue->data();

					if (!$row->store()) {
						// Install failed, roll back changes
						$dbstatus[$ename]->name = '<b>ext_' . $ename . '</b>';
						$dbstatus[$ename]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
					} else {
						$dbstatus[$ename]->name = '<b>ext_' . $ename . '</b>';
						$dbstatus[$ename]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';
					}
				
					$settings_element =& $xml->document->getElementByPath('settings');
					if (is_a($settings_element, 'JSimpleXMLElement') && count($settings_element->children())) {
						$settings =& $settings_element->children();
						foreach ($settings as $setting) {
							if ($setting->attributes('name')) {
								$query	= 'INSERT IGNORE INTO ' . $db->nameQuote('#__smms_settings') . ' (' . $db->nameQuote('key') . ', ' . $db->nameQuote('value') . ', ' . $db->nameQuote('field_type') . ') VALUES (' . $db->Quote($setting->attributes('name')) . ', ' . $db->Quote($setting->data()) . ', ' . $db->Quote($setting->attributes('fieldtype')) . ');';					
								$db->setQuery($query);
								if (!$db->query()) {
									$settings_status[$ename . '-' . $setting->attributes('name')]->name = '<b>ext_' . $ename . '</b> : ' . $setting->attributes('name');
									$settings_status[$ename . '-' . $setting->attributes('name')]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
								} else {
									$settings_status[$ename . '-' . $setting->attributes('name')]->name = '<b>ext_' . $ename . '</b> : ' . $setting->attributes('name');
									$settings_status[$ename . '-' . $setting->attributes('name')]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';								
								}
							}
						}
					}

					$defaultvalues_element =& $xml->document->getElementByPath('default_values');
					if (is_a($defaultvalues_element, 'JSimpleXMLElement') && count($defaultvalues_element->children())) {
						$defaultvalues =& $defaultvalues_element->children();
						foreach ($defaultvalues as $defaultvalue) {
							if ($defaultvalue->attributes('name')) {
								$query	= 'INSERT IGNORE INTO ' . $db->nameQuote('#__smms_defaults') . ' (' . $db->nameQuote('module_id') . ', ' . $db->nameQuote('fieldname') . ', ' . $db->nameQuote('fieldvalue') . ', ' . $db->nameQuote('formfield') . ') VALUES (' . $db->Quote($row->id) . ', ' . $db->Quote($defaultvalue->attributes('name')) . ', ' . $db->Quote($defaultvalue->attributes('value')) . ', ' . $db->Quote($defaultvalue->data()) . ');';					
								$db->setQuery($query);
								if (!$db->query()) {
									$defaultvalues_status[$ename . '-' . $defaultvalue->attributes('name')]->name = '<b>ext_' . $ename . '</b> : ' . $defaultvalue->attributes('name');
									$defaultvalues_status[$ename . '-' . $defaultvalue->attributes('name')]->text = '<p style="color: #600000">' . $db->getErrorMsg() . '</p>';
								} else {
									$defaultvalues_status[$ename . '-' . $defaultvalue->attributes('name')]->name = '<b>ext_' . $ename . '</b> : ' . $defaultvalue->attributes('name');
									$defaultvalues_status[$ename . '-' . $defaultvalue->attributes('name')]->text = '<p style="color: #006600">' . JText::_('Installed') . '</p>';								
								}
							}
						}
					}			
				
				// end file_exists
				}	
			} else {
				$dbstatus[$ename]->name = '<b>ext_' . $ename . '</b>';
				$dbstatus[$ename]->text = '<p style="color: #600000">' . JText::_('Already Installed') . '</p>';
			}
		
		//end foreach
		}


	$view = new SimpleMETAManagementView();
	$view->setModel( $model, true );
	$view->initialinstallation($dbstatus, $settings_status, $defaultvalues_status);

	//end function
	}
}

?>
