<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import library dependencies
jimport('joomla.application.component.controller');
jimport('joomla.html.pagination');
		
class SimpleMETAManagementController_manageurls extends JController {

	function __construct( $default = array()) {
		parent::__construct( $default );
	}

	function cancel() {
		$this->setRedirect( 'index.php?option=com_smms&view=manageurls' );
	}

	function backcpanel() {
		$this->setRedirect( 'index.php?option=com_smms' );
	}
	
	function apply() {
		SimpleMETAManagementController_manageurls::save(true);
	}

	function addurlapply() {
		SimpleMETAManagementController_manageurls::addurlsave(true);
	}

	function addurlsave($apply = false) {
		global $mainframe;

		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db							=& JFactory::getDBO();
		$address					= JRequest::getVar( 'address', null);
		$categoryid					= JRequest::getVar( 'categoryid', null);
		$option						= JRequest::getVar( 'option', 'com_smms' );
		$return						= JRequest::getVar( 'returntask', '', 'post' );

		$query	= 'SELECT * FROM #__smms_address WHERE address LIKE \'' . $address .'\'';		
		$db->setQuery($query);
		$results 	= $db->loadObjectList();
		$site 		= new stdClass;

		if (count($results) != 0) {
			$msg = JText::_('SMMS_MANAGEURLS_MESSAGE_URLEXISTS');
			$mainframe->redirect('index.php?option=' . $option . '&view=manageurls&task=addurl', $msg);	
		} else {
			$site->id 			= null;
			$site->address 		= $address;
			$site->categoryid 	= $categoryid;
			if (!$db->insertObject( '#__smms_address', $site, 'id' )) {
				echo $db->stderr();
				return false;
			}
		}

		$query	= 'SELECT'
				. ' name AS module_name'
				. ', category AS module_category'
				. ', databasename AS module_database'
				. ', pregmatch AS module_pregmatch'
				. ', pregmatch2 AS module_pregmatch2'
				. ', html AS module_html'
				. ', sqlupdatewithvalue AS database_sqlupdatewithvalue'
				. ', sqlupdatenovalue AS database_sqlupdatenovalue'
				. ' FROM #__smms_modules'
				. ' WHERE enabled = 1'
				. ' ORDER BY id';						
		$db->setQuery($query);
		$results = $db->loadObjectList();
		if (count($results) != 0) {
			foreach ($results as $result) {
				$form_customname 	= "custom_" . $result->module_name;
				$form_name			= $result->module_name;
				$form_nametitle		= $result->module_name . "_title";
				
				$$form_customname	= JRequest::getVar( "$form_customname", '', 'post' );
				$$form_name			= JRequest::getVar( "$form_name", '', 'post', 'string', JREQUEST_ALLOWRAW );
				$$form_nametitle	= JRequest::getVar( "$form_nametitle", '', 'post', 'string', JREQUEST_ALLOWRAW );

				$$form_name			= SimpleMETAManagementFunctions_common::sterilisetext($$form_name);
				$$form_nametitle	= SimpleMETAManagementFunctions_common::sterilisetext($$form_nametitle);		
		
				switch ($result->module_category) {
					case "feeds":
						$sql = 'INSERT INTO ' . $result->module_database . ' (site_id, ' . $form_customname . ', ' . $form_name . ', ' . $form_nametitle . ') VALUES (\''. $site->id .'\', \'' . ${$form_customname} . '\', \'' . ${$form_name} . '\', \'' . ${$form_nametitle} . '\')';
						break;
						
					default:
						$sql = 'INSERT INTO ' . $result->module_database . ' (site_id, ' . $form_customname . ', ' . $form_name . ') VALUES (\''. $site->id .'\', \'' . ${$form_customname} . '\', \'' . ${$form_name} . '\')';
						break;
				}
				
				$db->setQuery($sql);
				if (!$db->query()) {
					JError::raiseError( 500, $db->stderr() );
					return false;
				}
			}
		}

		$cache =& JFactory::getCache('com_smms');
		$cache->clean();

		if ($apply) {
			$msg = JText::_('SMMS_MANAGEURLS_MESSAGE_URLADDED');
			$mainframe->redirect('index.php?option='.$option.'&view=manageurls&task=edit&cid[]=' . $site->id, $msg);
		} else {
			$msg = JText::_('SMMS_MANAGEURLS_MESSAGE_URLADDED');
			$mainframe->redirect('index.php?option='.$option.'&view=manageurls', $msg);
		}
	}
		
	function save($apply = false) {
		global $mainframe;

		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db							=& JFactory::getDBO();
		$cid						= JRequest::getVar( 'cid', array(0), '', 'array' );
		JArrayHelper::toInteger($cid, array(0));
		$id							= JRequest::getVar( 'id', $cid[0], '', 'int' );
		$address					= JRequest::getVar( 'address', null);
		$categoryid					= JRequest::getVar( 'categoryid', null);
		$option						= JRequest::getVar( 'option', 'com_smms' );
		$return						= JRequest::getVar( 'returntask', '', 'post' );
		
		JArrayHelper::toInteger($cid);

		if (count($cid) < 1) {
			$msg =  JText::_('SMMS_MANAGEURLS_MESSAGE_IDEMPTY');
			$mainframe->redirect('index.php?option=' . $option . '&view=manageurls', $msg, 'error');
		}

		$query	= 'SELECT * FROM #__smms_address WHERE address LIKE \'' . $address .'\'';		
		$db->setQuery($query);
		$results 	= $db->loadObjectList();
		$site 		= new stdClass;

		if (count($results) != 0) {
			$query	= 'UPDATE #__smms_address SET address = \'' . $address . '\', categoryid = \'' . $categoryid . '\' WHERE id = \'' . $id . '\'';
			$db->setQuery($query);
			if (!$db->query()) {
				JError::raiseError( 500, $db->stderr() );
				return false;
			}
		}
		
		$query	= 'SELECT'
				. ' name AS module_name'
				. ', databasename AS module_database'
				. ', pregmatch AS module_pregmatch'
				. ', pregmatch2 AS module_pregmatch2'
				. ', html AS module_html'
				. ', sqlupdatewithvalue AS database_sqlupdatewithvalue'
				. ', sqlupdatenovalue AS database_sqlupdatenovalue'
				. ' FROM #__smms_modules'
				. ' WHERE enabled = 1'
				. ' ORDER BY id';						
		$db->setQuery($query);
		$results = $db->loadObjectList();
		if (count($results) != 0) {
			foreach ($results as $result) {
				$form_customname 	= "custom_" . $result->module_name;
				$form_name			= $result->module_name;
				$form_nametitle		= $result->module_name . "_title";
				
				$$form_customname	= JRequest::getVar( "$form_customname", '', 'post' );
				$$form_name			= JRequest::getVar( "$form_name", '', 'post', 'string', JREQUEST_ALLOWRAW );
				$$form_nametitle	= JRequest::getVar( "$form_nametitle", '', 'post', 'string', JREQUEST_ALLOWRAW );

				$$form_name			= SimpleMETAManagementFunctions_common::sterilisetext($$form_name);
				$$form_nametitle	= SimpleMETAManagementFunctions_common::sterilisetext($$form_nametitle);		
		
				if ($$form_customname) {
					$sql = $result->database_sqlupdatewithvalue;
				} else {
					$sql = $result->database_sqlupdatenovalue;
				}
				
				$sql = preg_replace('/\{DATABASENAME\}/Ui', $result->module_database, $sql);
				$sql = preg_replace('/\{SWITCH\}/Ui', ${$form_customname}, $sql);
				$sql = preg_replace('/\{VALUE\}/Ui', $$form_name, $sql);
				$sql = preg_replace('/\{TITLE\}/Ui', $$form_nametitle, $sql);
				$sql = preg_replace('/\{ID\}/Ui', $id, $sql);
				
				$db->setQuery($sql);
				if (!$db->query()) {
					JError::raiseError( 500, $db->stderr() );
					return false;
				}
			}
		}

		$cache =& JFactory::getCache('com_smms');
		$cache->clean();

		if ($apply) {
			$msg = JText::_('SMMS_MANAGEURLS_MESSAGE_URLUPDATED');
			$mainframe->redirect('index.php?option='.$option.'&view=manageurls&task=edit&cid[]='.$id, $msg);
		} else {
			$msg = JText::_('SMMS_MANAGEURLS_MESSAGE_URLSAVED');
			$mainframe->redirect('index.php?option='.$option.'&view=manageurls', $msg);
		}
	}
	
	function remove() {
		global $mainframe;
		
		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db			= & JFactory::getDBO();
		$cid		= JRequest::getVar( 'cid', array(), 'post', 'array' );
		$option		= JRequest::getCmd( 'option', 'com_smms' );
		$return		= JRequest::getCmd( 'returntask', '', 'post' );

		JArrayHelper::toInteger($cid);

		if (count($cid) < 1) {
			$msg =  JText::_('SMMS_MANAGEURLS_MESSAGE_IDEMPTY');
			$mainframe->redirect('index.php?option='.$option.'&view=manageurls', $msg, 'error');
		}

		$cids = implode(',', $cid);

		$query = 'DELETE FROM #__smms_address' .
				' WHERE id IN ( '. $cids. ' )';
		$db->setQuery($query);
		if (!$db->query())
		{
			JError::raiseError( 500, $db->getErrorMsg() );
			return false;
		}
		
		$query	= 'SELECT'
				. ' databasename AS module_database'
				. ' FROM #__smms_modules'
				. ' WHERE enabled = 1'
				. ' ORDER BY id';						
		$db->setQuery($query);
		$results = $db->loadObjectList();
		if (count($results) != 0) {
			foreach ($results as $result) {
				$query = 'DELETE FROM ' . $result->module_database
						. ' WHERE site_id IN ( '. $cids. ' )';
				$db->setQuery($query);
				if (!$db->query())
				{
					JError::raiseError( 500, $db->getErrorMsg() );
					return false;
				}
			}
		}
		
		$cache = & JFactory::getCache('com_smms');
		$cache->clean();

		$msg .= JText::_('SMMS_MANAGEURLS_MESSAGE_URLDELETED');
		$mainframe->redirect('index.php?option='.$option.'&view=manageurls&task='.$return, $msg);
	}

	function addurl() {
		global $mainframe;

		$model 			=& JModel::getInstance( 'SimpleMETAManagementModel' );
		$db				=& JFactory::getDBO();
		$user			=& JFactory::getUser();
		$document 		=& JFactory::getDocument();
		$settings 		=& SMMSModelSettings::getInstance();
		$option			= JRequest::getCmd( 'option', 'com_smms' );
		$rows 			= null;
		
		$query = 'SELECT cc.id AS value, cc.name AS text' .
				' FROM #__smms_categories AS cc' .
				' ORDER BY cc.name';
		$db	= & JFactory::getDBO();

		$categories[] = JHTML::_('select.option', '0', '- '.JText::_('SMMS_MANAGEURLS_LABEL_SELECTCATEGORY').' -');
		$db->setQuery($query);
		$categories = array_merge($categories, $db->loadObjectList());
		$category = JHTML::_('select.genericlist',  $categories, 'categoryid', 'class="inputbox" size="1"', 'value', 'text', $categoryid);
		$lists['categoryid'] 	= $category;

		$view = new SimpleMETAManagementView();
		$view->setModel( $model, true );
		$view->addurl($lists);
	}
	
	
	function edit() {
		global $mainframe;

		$model 			=& JModel::getInstance( 'SimpleMETAManagementModel' );
		$db				=& JFactory::getDBO();
		$user			=& JFactory::getUser();
		$document 		=& JFactory::getDocument();
		$settings 		=& SMMSModelSettings::getInstance();
		$option			= JRequest::getCmd( 'option', 'com_smms' );
		
		$use_sh404sef 	= $settings->get('use_sh404sef', 0);

		$cid			= JRequest::getVar( 'cid', array(0), '', 'array' );
		JArrayHelper::toInteger($cid, array(0));
		$id				= JRequest::getVar( 'id', $cid[0], '', 'int' );
		$option			= JRequest::getCmd( 'option' );

		if (count($cid) < 1) {
			$msg =  JText::_('SMMS_MANAGEURLS_MESSAGE_EMPTY');
			$mainframe->redirect('index.php?option='.$option.'&view=manageurls', $msg, 'error');
		}
		
		$categoryidquery = 'SELECT categoryid FROM #__smms_address WHERE id = \'' . $id . '\'';
		$db->setQuery( $categoryidquery );
		$categoryid = $db->loadResult();
		
		$where 		= array();
		$select 	= array();
		$leftjoin 	= array();
		$sqljoin 	= '';
		
		$from[] = '#__smms_address AS a';
		
		if ($search) {
			if ($use_sh404sef)
				$where[]		= 'LOWER(g.oldurl) LIKE ' . $db->Quote( '%'.$db->getEscaped( $search, true ).'%', false ) . ' OR LOWER(a.address) LIKE ' . $db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
			else 
				$where[] 		= 'LOWER(a.address) LIKE ' . $db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
		}
		
		$where[] = 'a.id = ' . $id;

		$query 				= 'SELECT COUNT(*) FROM #__smms_address';
		$db->setQuery( $query );
		$total = $db->loadResult();
		
		$pageNav = new JPagination( $total, $limitstart, $limit );

		$select[] = 'a.id AS id, a.address AS address';
		
		$query	= 'SELECT'
				. ' name AS module_name'
				. ', databasename AS module_database'
				. ', pregmatch AS module_pregmatch'
				. ', pregmatch2 AS module_pregmatch2'
				. ', html AS module_html'
				. ', sqlselect AS database_sqlselect'
				. ', sqljoin AS database_sqljoin'
				. ', sqlupdatewithvalue AS database_sqlupdatewithvalue'
				. ', sqlupdatenovalue AS database_sqlupdatenovalue'
				. ' FROM #__smms_modules'
				. ' WHERE enabled = 1'
				. ' ORDER BY id';						
		$db->setQuery($query);
		$results = $db->loadObjectList();
		if (count($results) != 0) {
			foreach ($results as $result) {
				$select[] = $result->database_sqlselect;

				$result->database_sqljoin = preg_replace('/\{DATABASENAME\}/Ui', $result->module_database, $result->database_sqljoin);
				if (!(preg_match("/" . $result->database_sqljoin . "/Ui", $sqljoin))) 
					$leftjoin[] = $result->database_sqljoin;
			}
		}
	
		if ($use_sh404sef) {
			$select[] = 'g.oldurl AS sefurl';
			$leftjoin[] = '#__redirection AS g ON g.newurl = a.address';
		}
		
		// Clean arrays
		$select 	= array_unique($select);
		$from 		= array_unique($from);
		$leftjoin 	= array_unique($leftjoin);
		$where 		= array_unique($where);

		// Build SQL Query Values
		$sqlselect 	= (count($select) 	? ' SELECT '.implode(', ', $select) : '');
		$sqlfrom 	= (count($from) 	? ' FROM '.implode(', ', $from) : '');
		$sqljoin 	= (count($leftjoin) ? ' LEFT JOIN '.implode(' LEFT JOIN ', $leftjoin) : '');
		$filter 	= (count($where) 	? ' WHERE '.implode(' AND ', $where) : '');
		
		// Build SQL Query
		$sql = $sqlselect;
		$sql .= $sqlfrom;
		$sql .= $sqljoin;
		$sql .= $filter
			. ' GROUP BY a.address'
			. $order
		;

		$db->setQuery( $sql, $pageNav->limitstart, $pageNav->limit );
		$rows = $db->loadObjectList();
		if ($db->getErrorNum()) {
			echo $db->stderr();
			return;
		}

		$db->setQuery($sql);
		$rows = $db->loadObjectList();
		if ($db->getErrorNum())	{
			echo $db->stderr();
			return;
		}

		$query = 'SELECT cc.id AS value, cc.name AS text' .
				' FROM #__smms_categories AS cc' .
				' ORDER BY cc.name';
		$db	= & JFactory::getDBO();

		$categories[] = JHTML::_('select.option', '0', '- '.JText::_('SMMS_MANAGEURLS_LABEL_SELECTCATEGORY').' -');
		$db->setQuery($query);
		$categories = array_merge($categories, $db->loadObjectList());
		$category = JHTML::_('select.genericlist',  $categories, 'categoryid', 'class="inputbox" size="1"', 'value', 'text', $categoryid);
		$lists['categoryid'] = $category;

		$view = new SimpleMETAManagementView();
		$view->setModel( $model, true );
		$view->edit($rows, $lists);
	}
	
	function display() {
		global $mainframe;

		$model 						=& JModel::getInstance( 'SimpleMETAManagementModel' );
		$table 						=& $model->getTable();
		$db							=& JFactory::getDBO();
		$settings 					=& SMMSModelSettings::getInstance();
		$option						= JRequest::getCmd( 'option', 'com_smms' );
		$filter_order				= $mainframe->getUserStateFromRequest( $option.'.filter_order',	'filter_order',	'a.address', 'cmd' );
		$filter_order_Dir			= $mainframe->getUserStateFromRequest( $option.'.filter_order_Dir',	'filter_order_Dir',	'asc',	'word' );
		$search						= $mainframe->getUserStateFromRequest( $option.'.search', 'search',	'',	'string' );
		$search						= JString::strtolower( $search );
		$categoryid					= $mainframe->getUserStateFromRequest($option. '.categoryid', 'categoryid', 0, 'int');
		$limit						= $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
		$limitstart					= $mainframe->getUserStateFromRequest( $option . '.limitstart', 'limitstart', 0, 'int' );
		$order 						= ' ORDER BY '. $filter_order .' '. $filter_order_Dir. ', a.address, a.id';
		
		$use_sh404sef 				= $settings->get('core_sh404sefurls', 0);
		$limitedinterface			= $settings->get('core_limitedinterface', 0);

		$where = array();
		$select = array();
		$leftjoin = array();
		$sqljoin 	= '';
		
		$from[] = '#__smms_address AS a';
		
		if ($search) {
			if ($use_sh404sef)
				$where[]		= 'LOWER(g.oldurl) LIKE ' . $db->Quote( '%'.$db->getEscaped( $search, true ).'%', false ) . ' OR LOWER(a.address) LIKE ' . $db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
			else 
				$where[] 		= 'LOWER(a.address) LIKE ' . $db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
		}
		
		// Category filter
		if ($categoryid > 0) {
			$where[] = 'a.categoryid = ' . (int) $categoryid;
		}
		$query 				= 'SET OPTION SQL_BIG_SELECTS = 1';
		$db->setQuery( $query );
		
		$query 				= 'SELECT COUNT(*) FROM #__smms_address';
		$db->setQuery( $query );
		$total = $db->loadResult();
		$pageNav = new JPagination( $total, $limitstart, $limit );

		$select[] = 'a.id AS id, a.address AS address';
		$select[] = 'z.name AS category_name';
		
		$query	= 'SELECT'
				. ' name AS module_name'
				. ', databasename AS module_database'
				. ', databasefield AS databasefield'
				. ', sqlselect AS database_sqlselect'
				. ', sqljoin AS database_sqljoin'
				. ' FROM #__smms_modules'
				. ' WHERE enabled = 1'
				. ' ORDER BY id';						
		$db->setQuery($query);
		$results = $db->loadObjectList();
		if (count($results) != 0) {
			foreach ($results as $result) {
				if ($limitedinterface)
					$select[] = $result->databasefield . ' AS custom_' . $result->module_name;
				else
					$select[] = $result->database_sqlselect;

				$result->database_sqljoin = preg_replace('/\{DATABASENAME\}/Ui', $result->module_database, $result->database_sqljoin);
				if (!(preg_match("/" . $result->database_sqljoin . "/Ui", $sqljoin))) 
					$leftjoin[] = $result->database_sqljoin;
			}
		}
	
		if ($use_sh404sef)
			$select[] = 'g.oldurl AS sefurl';


		$leftjoin[] = '#__smms_categories AS z ON z.id = a.categoryid';
		
		if ($use_sh404sef)
			$leftjoin[] = '#__redirection AS g ON g.newurl = a.address';
		
		// Clean arrays
		$select 	= array_unique($select);
		$from 		= array_unique($from);
		$leftjoin 	= array_unique($leftjoin);
		$where 		= array_unique($where);

		// Build SQL Query Values
		$sqlselect 	= (count($select) 	? ' SELECT '.implode(', ', $select) : '');
		$sqlfrom 	= (count($from) 	? ' FROM '.implode(', ', $from) : '');
		$sqljoin 	= (count($leftjoin) ? ' LEFT JOIN '.implode(' LEFT JOIN ', $leftjoin) : '');
		$filter 	= (count($where) 	? ' WHERE '.implode(' AND ', $where) : '');
		
		// Build SQL Query
		$sql = $sqlselect;
		$sql .= $sqlfrom;
		$sql .= $sqljoin;
		$sql .= $filter
			. ' GROUP BY a.address'
			. $order
		;

		$db->setQuery( $sql, $pageNav->limitstart, $pageNav->limit );
		$rows = $db->loadObjectList();
		if ($db->getErrorNum()) {
			echo $db->stderr();
			return;
		}
		
		$query = 'SELECT cc.id AS value, cc.name AS text' .
				' FROM #__smms_categories AS cc' .
				' ORDER BY cc.name';
		$db	= & JFactory::getDBO();

		$categories[] = JHTML::_('select.option', '0', '- '.JText::_('SMMS_MANAGEURLS_LABEL_SELECTCATEGORY').' -');
		$db->setQuery($query);
		$categories = array_merge($categories, $db->loadObjectList());
		$category = JHTML::_('select.genericlist',  $categories, 'categoryid', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', $categoryid);
		$lists['categoryid'] 	= $category;		
		$lists['order_Dir'] 	= $filter_order_Dir;
		$lists['order']			= $filter_order;
		$lists['search']		= $search;

		$view = new SimpleMETAManagementView();
		$view->setModel( $model, true );
		$view->display($rows, $pageNav, $lists);
	}
}

?>
