<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html 
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.application.component.controller' );

class SimpleMETAManagementController_settings extends JController
{
	function __construct( $default = array()) {
		parent::__construct( $default );
	}

	function backcpanel() {
		$this->setRedirect( 'index.php?option=com_smms' );
	}

	function display() {
		global $mainframe;

		$model 			=& JModel::getInstance( 'SimpleMETAManagementModel' );
		$db				=& JFactory::getDBO();
		$user			=& JFactory::getUser();
		$document 		=& JFactory::getDocument();
		$option			= JRequest::getCmd( 'option', 'com_smms' );

		$allmodules	= 'SELECT'
				. ' enabled AS module_enabled'
				. ', name AS module_name'
				. ' FROM #__smms_modules'
				. ' ORDER BY id';						
		$db->setQuery($allmodules);
		$rows = $db->loadObjectList();
		if ($db->getErrorNum()) {
			echo $db->stderr();
			return;
		}
		
		$emodules	= 'SELECT'
				. ' enabled AS module_enabled'
				. ', name AS module_name'
				. ' FROM #__smms_modules'
				. ' WHERE enabled = \'1\''
				. ' ORDER BY id';						
		$db->setQuery($emodules);
		$enabledmodules = $db->loadObjectList();
		if ($db->getErrorNum()) {
			echo $db->stderr();
			return;
		}

		foreach ($enabledmodules as $enabledmodule) {
			$settingssql = 'SELECT * FROM #__smms_settings WHERE `key` LIKE \'' . strtolower($enabledmodule->module_name) . '_%\' ORDER BY id';
			$db->setQuery($settingssql);
			$settingsql[$enabledmodule->module_name] = $db->loadObjectList();			
		}

		$view = new SimpleMETAManagementView();
		$view->setModel( $model, true );
		$view->display($rows, $lists, $enabledmodules, $settingsql);
	}

	function save() {
		global $mainframe;

		JRequest::checkToken() or jexit( 'Invalid Token' );

		$db				=& JFactory::getDBO();
		$option			= JRequest::getVar( 'option', 'com_smms' );
		$settings 		=& SMMSModelSettings::getInstance();
		
		$data = JRequest::getVar('var', array(), 'default', 'array');
		$settings->bindFromData($data);
		$settings->save();

		$cache =& JFactory::getCache('com_smms');
		$cache->clean();

		$msg = JText::sprintf('Settings saved', count($siteid));
		$mainframe->redirect('index.php?option=' . $option . '&view=settings', $msg);
	}
}

?>
