<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Extension Name
define('SMMS_SETTINGS_MODULE_KEYWORDS', 'KEYWORDS');

// Extension Language Strings
define('SMMS_MANAGEURLS_KEYWORDS_BOOLEAN_AUTOGENERATE', 'Auto Generate');
define('SMMS_MANAGEURLS_KEYWORDS_AUTOGENERATE', 'Auto Generate');
define('SMMS_SETTINGS_LABEL_KEYWORDS_ENCODING', 'Keyword Encoding');
define('SMMS_SETTINGS_LABEL_KEYWORDS_MINWORDLENGTH', 'Minimum length of single keywords');
define('SMMS_SETTINGS_LABEL_KEYWORDS_MINWORDOCCUR', 'Minimum occurence of single keywords');
define('SMMS_SETTINGS_LABEL_KEYWORDS_MIN2WORDSLENGTH', 'Minimum length of words for 2-keyword phrases; 0 will DISABLE !!!');
define('SMMS_SETTINGS_LABEL_KEYWORDS_MIN2WORDSPHRASELENGTH', 'Minimum length of 2-keyword phrases');
define('SMMS_SETTINGS_LABEL_KEYWORDS_MIN2WORDSPHRASEOCCUR', 'Minimum occurence of 2-keyword phrases');
define('SMMS_SETTINGS_LABEL_KEYWORDS_MIN3WORDSLENGTH', 'Minimum length of words for 3-keyword phrases; 0 will DISABLE !!!');
define('SMMS_SETTINGS_LABEL_KEYWORDS_MIN3WORDSPHRASELENGTH', 'Minimum length of 3-keyword phrases');
define('SMMS_SETTINGS_LABEL_KEYWORDS_MIN3WORDSPHRASEOCCUR', 'Minimum occurence of 3-keyword phrases');
//GEORGE BARDIS adding the blacklist label
define('SMMS_SETTINGS_LABEL_KEYWORDS_BLACKLIST', 'Keyword Blacklist');
//BARDIS ends

class SimpleMETAManagementFunctions_keywords {

	function booleanlist($name, $attribs = null, $selected = null, $yes='SMMS_GLOBAL_BOOLEAN_YES', $no='SMMS_GLOBAL_BOOLEAN_NO', $remove='SMMS_GLOBAL_BOOLEAN_REMOVE', $usedefault='SMMS_GLOBAL_BOOLEAN_USEDEFAULT', $autogenerate='SMMS_MANAGEURLS_KEYWORDS_BOOLEAN_AUTOGENERATE', $id=false) {
		$arr = array(
			JHTML::_('select.option',  '1', JText::_( $yes ) ),
			JHTML::_('select.option',  '0', JText::_( $no ) ),
			JHTML::_('select.option',  '2', JText::_( $remove ) ),
			JHTML::_('select.option',  '3', JText::_( $usedefault ) ),
			JHTML::_('select.option',  '4', JText::_( $autogenerate ) )
		);
		return SimpleMETAManagementFunctions_Common::radiolist($arr, $name, $attribs, 'value', 'text', (int) $selected, $id );
	}

    function selected( &$selection, $i, $title = NULL, $imgY = 'tick.png', $imgX = 'publish_x.png', $imgM = 'disabled.png', $imgD = 'publish_g.png', $imgE = 'publish_y.png') {
        $img	= $selection ? $imgY : $imgX;
        switch ($selection) {
			case "1":
				$img = $imgY;
				if ($title) {
					$action	= $title;
					$alt	= $title;
				} else {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_ACTIVE' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_ACTIVE' );
				}
				break;
				
			case "2":
				$img = $imgM;
				if ($title) {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_REMOVED' ) . ': ' . $title;
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_REMOVED' ) . ': ' . $title;
				} else {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_REMOVED' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_REMOVED' );
				}
				break;

			case "3":
				$img = $imgD;
				if ($title) {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_USINGDEFAULT' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_USINGDEFAULT' );
				} else {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_USINGDEFAULT' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_USINGDEFAULT' );
				}
				break;

			case "4":
				$img = $imgE;
				if ($title) {
					$action	= JText::_( 'SMMS_MANAGEURLS_KEYWORDS_BOOLEAN_AUTOGENERATE' );
					$alt	= JText::_( 'SMMS_MANAGEURLS_KEYWORDS_BOOLEAN_AUTOGENERATE' );
				} else {
					$action	= JText::_( 'SMMS_MANAGEURLS_KEYWORDS_BOOLEAN_AUTOGENERATE' );
					$alt	= JText::_( 'SMMS_MANAGEURLS_KEYWORDS_BOOLEAN_AUTOGENERATE' );
				}
				break;
				
			default:
				$img = $imgX;
				if ($title) {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_NOTACTIVE' ) . ': ' . $title;
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_NOTACTIVE' ) . ': ' . $title;
				} else {
					$action	= JText::_( 'SMMS_GLOBAL_MESSAGE_NOTACTIVE' );
					$alt	= JText::_( 'SMMS_GLOBAL_MESSAGE_NOTACTIVE' );
				}
				break;
		}

		$href	= '<a href="javascript:void(0);" title="'. $action .'"><img src="images/'. $img .'" border="0" alt="'. $alt .'" /></a>';
        return $href;
    }

	function simplebooleanlist($name, $attribs = null, $selected = null, $yes='SMMS_GLOBAL_BOOLEAN_YES', $no='SMMS_GLOBAL_BOOLEAN_NO', $autogenerate='SMMS_MANAGEURLS_KEYWORDS_AUTOGENERATE', $id=false) {
		$arr = array(
			JHTML::_('select.option',  '1', JText::_( $yes ) ),
			JHTML::_('select.option',  '0', JText::_( $no ) ),
			JHTML::_('select.option',  '4', JText::_( $autogenerate ) )
		);
		return SimpleMETAManagementFunctions_Common::radiolist($arr, $name, $attribs, 'value', 'text', (int) $selected, $id );
	}	

	function generateMeta($PageContent, $metatag, $settings) {
		if (file_exists(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'extensions'	. DS . 'keywords' . DS . 'class.autokeyword.php' ))
			require_once(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'extensions'	. DS . 'keywords' . DS . 'class.autokeyword.php' );

		$params['content'] 					= $PageContent;	
		$params['encoding'] 				= $settings->get('keywords_encoding', 'utf-8'); // case insensitive
		$params['lang'] 					= 'en'; // case insensitive
		// 1-word keywords
		$params['min_word_length'] 			= $settings->get('keywords_minwordlength', 2);  // min length of single words
		$params['min_word_occur']  			= $settings->get('keywords_minwordoccur', 5);  // min occur of single words
		// 2-word keyphrases
		$params['min_2words_length']        = $settings->get('keywords_min2wordslength', 4);  // min length of words for 2 word phrases; value 0 will DISABLE !!!
		$params['min_2words_phrase_length'] = $settings->get('keywords_min2wordsphraselength', 10); // min length of 2 word phrases
		$params['min_2words_phrase_occur']  = $settings->get('keywords_min2wordsphraseoccur', 3);  // min occur of 2 words phrase
		// 3-word keyphrases
		$params['min_3words_length']        = $settings->get('keywords_min3wordslength', 4);  // min length of words for 3 word phrases; value 0 will DISABLE !!!
		$params['min_3words_phrase_length'] = $settings->get('keywords_min3wordsphraselength', 12); // min length of 3 word phrases
		$params['min_3words_phrase_occur']  = $settings->get('keywords_min3wordsphraseoccur', 2);  // min occur of 3 words phrase
		//GEORGE BARDIS adding blacklist array parameter
		$params['blacklist'] 		 		= $settings->get('keywords_blacklist', 'test');  // the blacklisted keywords seperated by commas
		//Bardis ends
	
		$AutoKeywordGenerator = new AutoKeywordGenerator($params);

		$keywords = $AutoKeywordGenerator->get_keywords();

		$keywords = $AutoKeywordGenerator->removeDuplicateKw($keywords);
			
		return $keywords;
	}

	function setting_keywords_encoding($name, $selected = null, $id=false) {
		$encodinglist[] = JHTML::_('select.option',  'utf-8', JText::_('utf-8 (Unicode, Worldwide)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'utf-16', JText::_('utf-16 (Unicode, Worldwide)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-1', JText::_('iso-8859-1 (Western Europe)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-2', JText::_('iso-8859-2 (Central Europe)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-3', JText::_('iso-8859-3 (Southern Europe)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-4', JText::_('iso-8859-4 (North Europe)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-5', JText::_('iso-8859-5 (Cyrillic)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-6-i', JText::_('iso-8859-6-i (Arabic)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-7', JText::_('iso-8859-7 (Greek)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-8', JText::_('iso-8859-8 (Hebrew, visual)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-8-i', JText::_('iso-8859-8-i (Hebrew, logical)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-9', JText::_('iso-8859-9 (Turkish)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-10', JText::_('iso-8859-10 (Latin 6)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-11', JText::_('iso-8859-11 (Latin/Thai)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-13', JText::_('iso-8859-13 (Latin 7, Baltic Rim)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-14', JText::_('iso-8859-14 (Latin 8, Celtic)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-15', JText::_('iso-8859-15 (Latin 9)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-8859-16', JText::_('iso-8859-16 (Latin 10)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'us-ascii', JText::_('us-ascii (basic English)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'euc-jp', JText::_('euc-jp (Japanese, Unix)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'shift-jis', JText::_('shift_jis (Japanese, Win/Mac)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-2022-jp', JText::_('iso-2022-jp (Japanese, email)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'euc-kr', JText::_('euc-kr (Korean)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'gb2312', JText::_('gb2312 (Chinese, simplified)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'gb18030', JText::_('gb18030 (Chinese, simplified)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'big5', JText::_('big5 (Chinese, traditional)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'big5-HKSCS', JText::_('Big5-HKSCS (Chinese, Hong Kong)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'tis-620', JText::_('tis-620 (Thai)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'koi8-r', JText::_('koi8-r (Russian)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'koi8-u', JText::_('koi8-u (Ukrainian)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'iso-ir-111', JText::_('iso-ir-111 (Cyrillic KOI-8)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'macintosh', JText::_('macintosh (MacRoman)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'windows-1250', JText::_('windows-1250 (Central Europe)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'windows-1251', JText::_('windows-1251 (Cyrillic)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'windows-1252', JText::_('windows-1252 (Western Europe)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'windows-1253', JText::_('windows-1253 (Greek)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'windows-1254', JText::_('windows-1254 (Turkish)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'windows-1255', JText::_('windows-1255 (Hebrew)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'windows-1256', JText::_('windows-1256 (Arabic)'), 'id', 'title' );
		$encodinglist[] = JHTML::_('select.option',  'windows-1257', JText::_('windows-1257 (Baltic Rim)'), 'id', 'title' );
		
		$list			= JHTML::_('select.genericlist',  $encodinglist, $name, 'class="inputbox" size="1"', 'id', 'title', $selected);

		return $list;
	}	

}


?>