<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html 
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class SimpleMETAManagementFunctions_extensions {

	function showExtensionInfo(&$row) {
		$mosConfig_live_site = substr_replace(JURI::root(), "", -1, 1);
		
		echo "<div id=\"plugin" . $row->id . "\" class=\"plugin ";
		echo $row->enabled ? 'published' : 'unpublished';
		echo "\">";
		echo "	<div class=\"titlebar\">";
		echo "		<div class=\"tl tl1\">";
		echo "			<img src=\"" . $mosConfig_live_site . "/images/blank.png\" width=\"1\" height=1\" alt=\" \" />";
		echo "		</div>";
		echo "		<div class=\"tl tl2\">";
		echo "			<img src=\"" . $mosConfig_live_site . "/images/blank.png\" width=\"1\" height=\"1\" alt=\" \" />";
		echo "		</div>";
		echo "		<div class=\"tl tl3\">";
		echo "			<img src=\"" . $mosConfig_live_site . "/images/blank.png\" width=\"1\" height=\"1\" alt=\" \" />";
		echo "		</div>";
		echo "		<div class=\"tl\">";
        echo "			<div class=\"pluginname\"><b>" . $row->name . "</b></div>";
		echo "			<div class=\"pluginversion\">";
		echo 				@$row->version != "" ? $row->version : "&nbsp;";
		echo "			</div>";
        echo "			<div class=\"spacer\"></div>";
		echo "		</div>";
        echo "	</div>";
        echo "	<div class=\"insidebox\">";
		echo "		<div class=\"plugindate\">";
		echo 			@$row->creationdate != "" ? $row->creationdate : "&nbsp;";
		echo "		</div>";
		echo "		<div class=\"pluginauthor\">" . JText::_('SMMS_EXTENSIONS_LABEL_AUTHOR') . ': ';
		echo 			@$row->author != "" ? $row->author : JText::_('SMMS_EXTENSIONS_MESSAGE_UNKNOWNAUTHOR');
		echo 			@$row->authorEmail != "" ? ' &lt;'.$row->authorEmail.'&gt;' : "&nbsp;";
		echo "		</div>";
		echo "		<div class=\"pluginauthorurl\">";
		echo 			@$row->authorUrl != "" ? "<a href=\"" . (substr( $row->authorUrl, 0, 7) == 'http://' ? $row->authorUrl : 'http://' . $row->authorUrl) . "\" target=\"_blank\">$row->authorUrl</a>" : "&nbsp;";
		echo "		</div>";
        echo "		<div class=\"plugintaskbar\">";
		echo "			<a href=\"index.php?option=com_smms&view=extensions&task=uninstallExtension&extensionid=" . $row->id . "\">" . JText::_('SMMS_EXTENSIONS_LABEL_UNINSTALLEXTENSION') . "</a>";
		echo "			<a href=\"index.php?option=com_smms&view=extensions&task=changeExtensionState&extensionid=" . $row->id . "\">";
		echo "				<img id=\"pluginstate" . $row->id . "\" src=\"images/";
		$image = $row->enabled ? "publish_g.png\" title=\"" . JText::_('SMMS_EXTENSIONS_MESSAGE_PUBLISHED') . "\"" : "publish_x.png\" title=\"" . JText::_('SMMS_EXTENSIONS_LABEL_UNPUBLISHED') . "\"";
		echo $image;
		echo "\" border=\"0\" />";
		echo "			</a>";
		echo "		</div>";
        echo "	</div>";
        echo "</div>";
	}

	function loadInstalledExtensions( &$rows, &$xmlfile ) {
		$database = & JFactory::getDBO();

		if (!defined('DOMIT_INCLUDE_PATH') ) {
           	require_once (JPATH_SITE . DS . 'libraries' . DS . 'domit' . DS . 'xml_domit_lite_parser.php');
		}

		$query = "SELECT id, enabled, name"
				. "\n FROM #__smms_modules"
				. "\n ORDER BY name";

		$database->setQuery( $query );
		$rows = $database->loadObjectList();

		$n = count( $rows );
		for ($i = 0; $i < $n; $i++) {
			$row =& $rows[$i];

			// path to module directory
			$extensionBaseDir = JPATH_COMPONENT_ADMINISTRATOR . DS . 'extensions' . DS;

			// xml file for module
			$xmlfile = $extensionBaseDir . "ext." . $row->name . ".xml";

			if (file_exists( $xmlfile )) {
				$xmlDoc = new DOMIT_Lite_Document();
				$xmlDoc->resolveErrors( true );
				if (!$xmlDoc->loadXML( $xmlfile, false, true )) {
					continue;
				}

				$root = &$xmlDoc->documentElement;

				if ($root->getTagName() != 'smms_extension') {
					continue;
				}
				
				if ($root->getAttribute( "type" ) != "smms_ext") {
					continue;
				}

				$element 			= &$root->getElementsByPath( 'name', 1 );
				$row->name		 	= $element ? $element->getText() : '';

				$element 			= &$root->getElementsByPath( 'creationDate', 1 );
				$row->creationdate 	= $element ? $element->getText() : '';

				$element 			= &$root->getElementsByPath( 'author', 1 );
				$row->author 		= $element ? $element->getText() : '';

				$element 			= &$root->getElementsByPath( 'copyright', 1 );
				$row->copyright 	= $element ? $element->getText() : '';

				$element 			= &$root->getElementsByPath( 'authorEmail', 1 );
				$row->authorEmail 	= $element ? $element->getText() : '';

				$element 			= &$root->getElementsByPath( 'authorUrl', 1 );
				$row->authorUrl 	= $element ? $element->getText() : '';

				$element 			= &$root->getElementsByPath( 'version', 1 );
				$row->version 		= $element ? $element->getText() : '';
			}else {
				echo JText::_('SMMS_EXTENSIONS_MESSAGE_MISSINGXMLFILE') . "'$xmlfile'";
			}
		}
	}

}

?>