<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Make sure SMMS is enabled
jimport('joomla.application.component.helper');
jimport('joomla.utilities.date');

if (!JComponentHelper::isEnabled('com_smms', true))
{
	JError::raiseError('E_SMMSNOTENABLED', JText('SMMS_MODULE_ERROR_NOTENABLED'));
	return;
}

require_once( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'models' . DS . 'settings.php' );

$document 	=& JFactory::getDocument();
$db			=& JFactory::getDBO();
$lang 		=& JFactory::getLanguage();
$settings 	=& SMMSModelSettings::getInstance();

$document->addStyleSheet(JURI::base() . 'components/com_smms/assets/css/smms.css');

$enable_urls 			= $settings->get('module_enableurls', 0);
$enable_categories 		= $settings->get('module_enablecategories', 0);
$enable_findandreplace 	= $settings->get('module_enablefindandreplace', 0);


	function createButton($link, $img, $text, $value = 0) {
		$button = "<div style=\"float:left;\">\n";
		$button .= "<div class=\"icon\">\n";
		$button .= "<a href=\"" . $link . "\">\n";
		$button .= "<img src=\"components/com_smms/assets/images/" . $img . ".png\" />\n";
		$button .= "<span>" . $text . " (" . $value . ")</span>\n";
		$button .= "</a>\n";
		$button .= "</div>\n";
		return $button;
	}

	echo "<div class=\"smmscpanel\">\n";
	
	if ($enable_urls) {
		$query 	= 'SELECT COUNT(*) FROM #__smms_address';
		$db->setQuery( $query );
		$value 		= $db->loadResult();
		$link		= JRoute::_('index.php?option=com_smms&view=manageurls');
		$img		= 'manageurls';
		$text 		= JText::_('SMMS_MODULE_TOTALURLS');
		
		$button = createButton($link, $img, $text, $value);
		echo $button;
	}

	if ($enable_categories) {
		$query 	= 'SELECT COUNT(*) FROM #__smms_categories WHERE enabled = 1';
		$db->setQuery( $query );
		$value 		= $db->loadResult();
		$link		= JRoute::_('index.php?option=com_smms&view=categories');
		$img		= 'categories';
		$text 		= JText::_('SMMS_MODULE_TOTALCATEGORIES');
		
		$button = createButton($link, $img, $text, $value);
		echo $button;
	}
	
	if ($enable_findandreplace) {
		$query 	= 'SELECT COUNT(*) FROM #__smms_replace WHERE replace_enabled = 1';
		$db->setQuery( $query );
		$value 		= $db->loadResult();
		$link		= JRoute::_('index.php?option=com_smms&view=findandreplace');
		$img		= 'findandreplace';
		$text 		= JText::_('SMMS_MODULE_TOTALFINDANDREPLACE');
		
		$button = createButton($link, $img, $text, $value);
		echo $button;
	}
	
	echo "</div>\n";
	
?>