<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *  
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

require_once( JPATH_ROOT . DS . 'components' . DS . 'com_easyblog' . DS . 'constants.php' );
require_once( EBLOG_CLASSES . DS . 'facebook' . DS . 'consumer.php' );

class EasyBlogFacebook extends Facebook
{
	var $callback		= '';
	var $_access_token	= '';
	
	public function __construct( $key , $secret , $callback )
	{
		$this->callback	= $callback;

		parent::__construct( array( 'appId' 	=> $key ,
									'secret'	=> $secret,
									'cookie'	=> true
							) 
		);
	}
	
	/**
	 * Facebook does not need the request tokens
	 * 
	 **/	 	 	
	public function getRequestToken()
	{
		$obj		= new stdClass();
		$obj->token		= 'facebook';
		$obj->secret	= 'facebook';
		
		return $obj;
	}

	/**
	 * Returns the verifier option. Since Facebook does not have oauth_verifier,
	 * The only way to validate this is through the 'code' query
	 * 
	 * @return string	$verifier	Any string representation that we can verify it isn't empty.	 	 
	 **/	 	 	
	public function getVerifier()
	{
		$verifier	= JRequest::getVar( 'code' , '' );
		return $verifier;
	}

	/**
	 * Returns the authorization url.
	 * 
	 * @return string	$url	A link to Facebook's login URL.	 	 
	 **/
	public function getAuthorizationURL( $token )
	{
		$scope	= array( 
							'publish_stream',
							'user_likes',
							'offline_access',
							'manage_pages',
							'user_status'
						);
		$url	= 'http://facebook.com/dialog/oauth?scope=' . implode( ',' , $scope ) . '&client_id=' . parent::getAppId() . '&redirect_uri=' . urlencode( $this->callback ) . '&response_type=code';

		return $url;
	}
	
	public function getAccess( $token , $secret , $verifier )
	{
		$code		= JRequest::getVar( 'code' );
		$params		= array( 'client_id' 	=> parent::getAppId() ,
							 'redirect_uri'	=> $this->callback,
							 'client_secret'=> parent::getApiSecret(),
							 'code'			=> $code
							);

		$token		= parent::_oauthRequest( parent::getUrl('graph', '/oauth/access_token' ) , $params );
		$token		= str_ireplace( 'access_token=' , '' , $token );
		$obj		= new stdClass();
		$obj->token	= $token;
		$obj->secret= 'facebook';
		$obj->params= '';
		
		return $obj;
	}
	
	/**
	 * Shares a new content on Facebook
	 **/	 	 	
	public function share( $blog , $message = '' , $oauth , $useSystem = false )
	{
		$config		= EasyBlogHelper::getConfig();
		$source		= $config->get( 'integrations_facebook_source' );
		
		$content	= isset( $blog->$source ) && !empty( $blog->$source ) ? $blog->$source : $blog->intro;

		$content	= EasyBlogHelper::getHelper( 'Videos' )->strip( $content );
		
		// @rule: Match images from blog post
		$pattern	= '/<\s*img [^\>]*src\s*=\s*[\""\']?([^\""\'\s>]*)/i';
		preg_match( $pattern , $content , $matches );

		$image		= '';

		if( $matches )
		{
			$image		= isset( $matches[1] ) ? $matches[1] : '';

			if( JString::stristr( $matches[1], 'https://' ) === false && JString::stristr( $matches[1], 'http://' ) === false && !empty( $image ) )
			{
				$image	= rtrim(JURI::root(), '/') . '/' . ltrim( $image, '/');
			}
		}
		
		$maxContentLen  = $config->get( 'integrations_facebook_blogs_length' );

		$text		= strip_tags( $content );
		
		if( !empty( $maxContentLen ) )
		{
		    $text       = ( JString::strlen( $text ) > $maxContentLen ) ? JString::substr( $text, 0, $maxContentLen) . '...' : $text;
		}
		
		$url		= EasyBlogRouter::getRoutedURL( 'index.php?option=com_easyblog&view=entry&id=' . $blog->id , false , true );

		preg_match( '/expires=(.*)/i', $this->_access_token , $expires );

		if( isset( $expires[1]) )
		{
			$this->_access_token	= str_ireplace( '&expires=' . $expires[1] , '' , $this->_access_token );
		}
		
		$jConfig	= JFactory::getConfig();
		$params		= array( 
							'link' 			=>  $url, 
							'name'			=> $blog->title,
							'actions'		=> '{"name": "' . JText::sprintf( 'COM_EASYBLOG_INTEGRATIONS_FACEBOOK_VIEWON_BUTTON' , $jConfig->getValue( 'sitename' ) ) . '", "link" : "' . $url . '"}',
							'description' 	=> $text,
							'access_token' 	=> $this->_access_token
							);

		if( !empty( $image ) )
		{
			// Since Facebook does not allow https images we need to replace them here.
			$params[ 'picture' ] 	= str_ireplace( 'https://' , 'http://' , $image );
			$params[ 'source' ] 	= str_ireplace( 'https://' , 'http://' , $image );
		}
		else
		{
			$params['picture' ]		= rtrim( JURI::root() , '/' ) . '/components/com_easyblog/assets/images/default_facebook.png';
			$params['source' ]		= rtrim( JURI::root() , '/' ) . '/components/com_easyblog/assets/images/default_facebook.png';
		}


		// @rule: For system messages, we need to see if there's any pages associated.
		if( $oauth->system && $useSystem )
		{
			if( $config->get( 'integrations_facebook_impersonate_page' ) )
			{
				$pages	= JString::trim( $config->get( 'integrations_facebook_page_id' ) );
				$pages	= explode( ',' , $pages );
				$total	= count( $pages );

				// @rule: Test if there are any pages at all the user can access
				$accounts	= parent::api( '/me/accounts' , array( 'access_token' => $this->_access_token ) );

				if( is_array( $accounts ) && isset( $accounts[ 'data' ] ) )
				{
					for( $i = 0; $i < $total; $i++ )
					{
						foreach( $accounts[ 'data' ] as $page )
						{
							if( $page[ 'id' ] == $pages[ $i ] )
							{
								$params['access_token']	= $page[ 'access_token' ];
								$query	= parent::api( '/' . $page[ 'id' ] . '/feed' , 'post' , $params );
							}
						}
					}
				}
			}
			else
			{
				// @rule: Just query the admin's account
				$query	= parent::api( '/me/feed' , 'post' , $params );
			}
		}
		else
		{
			// @rule: If this is just a normal posting, just post it on their page.
			$query		= parent::api( '/me/feed' , 'post' , $params );
		}

		$success	= isset( $query['id'] ) ? true : false;
		
		return $success;
	}

    function findItem($needle, $haystack, $partial_matches = false, $search_keys = false)
	{
        if(!is_array($haystack)) return false;
        foreach($haystack as $key=>$value) {
            $what = ($search_keys) ? $key : $value;
            if($needle===$what) return $key;
            else if($partial_matches && @strpos($what, $needle)!==false) return $key;
            else if(is_array($value) && self::findItem($needle, $value, $partial_matches, $search_keys)!==false) return $key;
        }
        return false;
    }
	
	public function setAccess( $access )
	{
		$access	= new JParameter( $access );
		
		$this->_access_token	= $access->get( 'token' );
		return true;
	}
	
	public function revokeApp()
	{
		return true;
	}
}