<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *  
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

require_once( JPATH_ROOT . DS . 'components' . DS . 'com_easyblog' . DS . 'constants.php' );
require_once( EBLOG_CLASSES . DS . 'twitter' . DS . 'consumer.php' );

class EasyBlogTwitter extends TwitterOAuth
{
	var $callback = '';
	
	public function __construct( $key , $secret , $callback )
	{
		parent::__construct($key, $secret);
		$this->callback = $callback;
	}
	
	public function getRequestToken()
	{
		$request		= parent::getRequestToken($this->callback);

		$obj			= new stdClass();
		$obj->token		= $request['oauth_token'];
		$obj->secret	= $request['oauth_token_secret'];
		
		return $obj;
	}
	
	public function getAuthorizationURL( $token, $auto_sign_in=false )
	{
		return parent::getAuthorizeURL( $token, $auto_sign_in );
	}
	
	public function getVerifier()
	{
		$verifier	= JRequest::getVar( 'oauth_verifier' , '' );
		return $verifier;
	}
	
	public function getAccess( $token , $secret , $verifier )
	{
		$this->token = new OAuthConsumer($token, $secret);
		
		$access = $this->getAccessToken($verifier);
		
		if(empty($access['oauth_token']) && empty($access['oauth_token_secret']))
		{
			return false;
		}

		$obj		= new stdClass();

		$obj->token	= $access['oauth_token'];
		$obj->secret= $access['oauth_token_secret'];

		$param			= new JParameter('');
		$param->set( 'user_id' 	, $access['user_id'] );
		$param->set( 'screen_name' 	, $access['screen_name'] );
		
		$obj->params	= $param->toString();
		//@todo: expiry
		
		return $obj;
	}
	
	/**
	 * Shares a new content on Twitter
	 **/ 	
	public function share( $blog , $message = '' , $oauth , $useSystem = false )
	{
		$content =  $this->processMessage($message, $blog);
		
		$parameters 	= array('status' => $content);
		$result 		= $this->post('statuses/update', $parameters);
		$status			= array('success'=>true, 'error'=>false);
		
 		//for issues with unable to authenticate error, somehow they return errors instead of error.
		if( isset( $result->errors[0]->message ) )
		{
			$status['success'] = false;
			$status['error'] = $result->errors[0]->message;
		}
		
		//for others error that is not authentication issue.
		if( isset( $result->error ) )
		{	
			$status['success'] = false;
			$status['error'] = $result->error;
		}
		
		return $status['success'];		
	}
	
	public function setAccess( $access )
	{
		$access	= new JParameter( $access );
		$this->token = new OAuthConsumer($access->get('token'), $access->get( 'secret'));
		return $this->token;
	}
	
	public function revokeApp()
	{
		return true;
	}
	
	/**
	 * Process message
	 **/
	function processMessage($MsgTemplate, $blog)
	{
		$config		=& EasyBlogHelper::getConfig();
		$message	= empty($MsgTemplate)? $config->get('main_twitter_message') : $MsgTemplate;
		$search		= array();
		$replace	= array();
		
		//replace title
		if (preg_match_all("/.*?(\\{title\\})/is", $message, $matches))
		{
			$search[] = '{title}';
		    $replace[] = $blog->title;
		}
		
		//replace title
		if (preg_match_all("/.*?(\\{introtext\\})/is", $message, $matches))
		{
			$introtext = empty($blog->intro)? '' : strip_tags( $blog->intro );
			
			$search[] = '{introtext}';
		    $replace[] = $introtext;
		}
		
		//replace category
		if (preg_match_all("/.*?(\\{category\\})/is", $message, $matches))
		{
			$category 	=& EasyBlogHelper::getTable( 'ECategory', 'Table' );
			$category->load($blog->category_id);
			
			$search[]	= '{category}';
		    $replace[]	= $category->title;
		}
		
		$message = JString::str_ireplace($search, $replace, $message);
		
		//replace link
		if (preg_match_all("/.*?(\\{link\\})/is", $message, $matches))
		{
			$link = EasyBlogRouter::getRoutedURL('index.php?option=com_easyblog&view=entry&id=' . $blog->id, false, true);
			
			if($config->get('main_twitter_shorten_url'))
			{
				$shortenerLogin		= $config->get('main_twitter_urlshortener_login');
				$shortenerApiKey	= $config->get('main_twitter_urlshortener_apikey');
				
				if(!empty($shortenerLogin) && !empty($shortenerApiKey))
				{
					require_once( EBLOG_HELPERS . DS . 'urlshortener.php' );
					
					$urlshortener	= new EasyBlogURLShortenerHelper();
					$result			= $urlshortener->get_short_url($shortenerLogin, $shortenerApiKey, $link, 'bitly');
					
					if(!empty($result))
					{
						$link = $result;
					}
				}
			}
			
			//get available spaces.
			$linkLength			= strlen($link);			
			$remainingLength	= 140 - $linkLength;
						
			//split the message
			$tempMsg = explode('{link}', $message);
			
			for($i = 0; $i < count($tempMsg); $i++)
			{
			    $temp   =& $tempMsg[$i];
			    
				$tempLength = strlen($temp);
				if(($tempLength > $remainingLength))
				{
					if($remainingLength<=0)
					{
						$temp = JString::substr($temp, 0, 0);
					}
					else
					{
						if($remainingLength < 6)
						{
							$temp = JString::substr($temp, 0, $remainingLength);
						}
						else
						{
							$temp = JString::substr($temp, 0, $remainingLength - 3);
							$temp .= '.. ';
						}
						
						$remainingLength = 0;
					}
				}
				else
				{
					$remainingLength -= $tempLength;
				}
			}
			
			$message = implode($link, $tempMsg);
		}
		
		return JString::substr($message, 0, 140);
	}
}