<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *  
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

require_once( EBLOG_HELPERS . DS . 'image.php' );

class EasyBlogIntegrate
{
	function integrate( $profile )
	{
		static $loaded	= null;

		if( !isset( $loaded[ $profile->id ] ) )
		{
			$config		=& EasyBlogHelper::getConfig();
			$IntegratedComponent = 'EasyBlogIntegrate'.$config->get( 'layout_avatarIntegration', 'default' );
			
			$class = new $IntegratedComponent;
	
			//@task: For guest, we use default avatar.
			if( $profile->id == 0 )
			{
				$profile->avatar 		= JURI::root() . 'components/com_easyblog/assets/images/default_blogger.png';
				$profile->avatarWidth	= 64;
				$profile->avatarHeight	= 64;
				$profile->profileLink	= '';
				$loaded[ $profile->id ]	= $profile;
				return $loaded[ $profile->id ];
			}

			if($class->_init())
			{
				$avatar = $class->_getAvatar($profile);
				$profile->avatar 		= empty($avatar->link)? JURI::root().$profile->avatar : $avatar->link;
				$profile->avatarWidth	= empty($avatar->width)? '60' : $avatar->width;
				$profile->avatarHeight	= empty($avatar->height)? '60' : $avatar->height;
				$profile->profileLink	= $class->_getLink($profile);
			}		
			else
			{
				$class = new EasyBlogIntegrateDefault();			
				$avatar = $class->_getAvatar($profile);
				$profile->avatar 		= $avatar->link;
				$profile->avatarWidth	= $avatar->width;
				$profile->avatarHeight	= $avatar->height;
				$profile->profileLink 	= $class->_getLink($profile);
			}
			
			$loaded[ $profile->id ]	= $profile;
		}
		return $loaded[ $profile->id ];
	}
}

class EasyBlogIntegrateDefault 
{
	function _init()
	{
		return true;
	}
	
	function _getAvatar($profile)
	{
		$imagePath  	= $profile->getAvatar();
		$imagePath  	= str_replace('/', DS, $imagePath);		
		$targetImage    = $profile->getAvatar();
		
		if(!JFile::exists(JPATH_ROOT.DS.$imagePath))
		{
			$targetImage	= '/components/com_easyblog/assets/images/default_blogger.png';
		}
		
		$dimension = EasyImageHelper::getAvatarDimension($targetImage);
		
		$avatar = new stdClass();
		$avatar->link	= JURI::root().$targetImage;
		$avatar->width	= $dimension[0];
		$avatar->height	= $dimension[1];
				
		return $avatar;
	}
	
	function _getLink($profile)
	{
		$link = EasyBlogRouter::_('index.php?option=com_easyblog&view=blogger&layout=listings&id='.$profile->id, false);
		return $link;
	}
}

class EasyBlogIntegrateJomsocial
{
	function _init()
	{
		$files	= JPATH_ROOT . DS . 'components' . DS. 'com_community' . DS . 'libraries' . DS . 'core.php';
		
		if(!JFile::exists( $files ))
		{
			return false;
		}
		
		require_once( $files );
			
		return true;		
	}
	
	function _getAvatar($profile)
	{
		$user	=& CFactory::getUser( $profile->id );
		$source	= $user->getThumbAvatar();
		
		$dimension	= EasyImageHelper::getAvatarDimension(str_replace( JURI::root(), '', $source));
		
		$avatar = new stdClass();
		$avatar->link	= $source;
		$avatar->width	= $dimension[0];
		$avatar->height	= $dimension[1];
		
		return $avatar;
	}
	
	function _getLink($profile)
	{
		return CRoute::_('index.php?option=com_community&view=profile&userid=' . $profile->id );
	}
}

class EasyBlogIntegrateKunena
{

	function _init()
	{
		$files	= JPATH_ROOT . DS . 'components' . DS. 'com_kunena' . DS . 'class.kunena.php';		
		
		if(!JFile::exists( $files ))
		{
			return false;
		}
		
		return true;		
	}
	
	function _getAvatar($profile)
	{
		$db	=& JFactory::getDBO();
		
		//$sql = 'SELECT a.*, b.* FROM #__fb_users AS a INNER JOIN #__users AS b ON b.id=a.userid WHERE a.userid='.$db->quote($profile->id);	
		$sql = 'SELECT a.*, b.* FROM #__kunena_users AS a INNER JOIN #__users AS b ON b.id=a.userid WHERE a.userid='.$db->quote($profile->id);		
		$db->setQuery($sql);

    	$user 	= $db->loadObject();
    	//$path	= 'images/fbfiles/avatars';
    	$path	= 'media/kunena/avatars';
    	$source	= empty($user->avatar)? 'nophoto.jpg' : str_replace( '{', '', $user->avatar);
    	
    	$dimension	= EasyImageHelper::getAvatarDimension($path . DS . $source);
		
		$avatar = new stdClass();
		$avatar->link	= JURI::root() . $path . '/' . $source;
		$avatar->width	= $dimension[0];
		$avatar->height	= $dimension[1];
    	
    	return $avatar;    	
	}
	
	function _getLink($profile)
	{
		return EasyBlogRouter::_('index.php?option=com_kunena&func=fbprofile&userid='.$profile->id, false);
	}
}

class EasyBlogIntegrateCommunityBuilder
{
	function _init()
	{
		$files = JPATH_ROOT . DS . 'administrator' . DS . 'components' .DS. 'com_comprofiler' .DS. 'plugin.foundation.php';
        
		if(!JFile::exists( $files ))
		{
			return false;
		}
		
		require_once( $files );
		cbimport('cb.database');
		cbimport('cb.tables');
		cbimport('cb.tabs');
		
		return true;
	}

	function _getAvatar($profile)
	{		
		$user =& CBuser::getInstance( $profile->id ); 		
		if (!$user) 
		{
			$user =& CBuser::getInstance( null );
		}
		
		$field	=	$user->getField( 'avatar', null, 'php', 'none', 'list' );
		$source	=	$field['avatar'];
		
		//incase we view from backend. we need to remove the /administrator/ from the path.
		$source = str_replace('/administrator/','/', $source);
						
		$dimension	= EasyImageHelper::getAvatarDimension(str_replace( JURI::root(), '', $source));
		
		$avatar = new stdClass();
		$avatar->link	= $source;
		$avatar->width	= $dimension[0];
		$avatar->height	= $dimension[1];
		
		return $avatar;
	}
	
	function _getLink($profile)
	{
		$cbItemid = getCBprofileItemid();
				
		$link = EasyBlogRouter::_('index.php?option=com_comprofiler&task=userProfile&user='.$profile->id.'&Itemid='.$cbItemid, false);
		
		return $link;
	}
}
	
class EasyBlogIntegrateGravatar
{	
	function _init()
	{
        return true;
	}

	function _getAvatar($profile)
	{
		$user =& JFactory::getUser($profile->id);
		
		$avatar = new stdClass();	
		$avatar->link	= 'http://www.gravatar.com/avatar.php?gravatar_id=' . md5($user->email)
	            		//. '&amp;default=' . urlencode(JURI::root().$profile->avatar)
						. '&amp;size=60';
		$avatar->width	= '60';
		$avatar->height	= '60';
		
		return $avatar;
	}
	
	function _getLink($profile)
	{
		$link = EasyBlogRouter::_('index.php?option=com_easyblog&view=blogger&layout=listings&id='.$profile->id, false);
		return $link;
	}
}
	
class EasyBlogIntegratePhpBB
{
	var $files;
	var $phpbbpath;
	var $phpbbuserid;
	
	function _init()
	{
		$config =& EasyBlogHelper::getConfig();		
		$this->phpbbpath = $config->get( 'layout_phpbb_path' );
		
		$this->files = JPATH_ROOT . DS . $this->phpbbpath . DS . 'config.php';    
	    
	    if(!JFile::exists( $this->files ))
		{
			return false;
		}
		
		return true;		
	}
	
	function _getAvatar($profile)
	{
		$phpbbDB = $this->_getPhpbbDBO();
		$phpbbConfig = $this->_getPhpbbConfig();
		
		if(empty($phpbbConfig))
		{
			return false;
		}
		
		$juser	=& JFactory::getUser( $profile->id );
			
		$sql	= 'SELECT '.$phpbbDB->nameQuote('user_id').', '.$phpbbDB->nameQuote('username').', '.$phpbbDB->nameQuote('user_avatar').', '.$phpbbDB->nameQuote('user_avatar_width').', '.$phpbbDB->nameQuote('user_avatar_height').', '.$phpbbDB->nameQuote('user_avatar_type').' '
				. 'FROM '.$phpbbDB->nameQuote('#__users').' WHERE LOWER('.$phpbbDB->nameQuote('username').') = LOWER('.$phpbbDB->quote($juser->username).') '
				. 'LIMIT 1';
		$phpbbDB->setQuery($sql);
		$result = $phpbbDB->loadObject();
		
		$this->phpbbuserid = empty($result->user_id)? '0' : $result->user_id;
		
		if(!empty($result->user_avatar))
		{
			//avatar upload		1
			//avatar remote		2
			//avatar gallery	3		
			switch($result->user_avatar_type)
			{
				case '1':
					$subpath	= $phpbbConfig->avatar_upload_path;
					$phpEx 		= JFile::getExt(__FILE__);				
					$source		= JURI::root().$this->phpbbpath.'/download/file.'.$phpEx.'?avatar='.$result->user_avatar;
					//$source		= JURI::root().$this->phpbbpath.'/'.$subpath.'/'.$result->user_avatar;					
					break;
				case '2':
					$source		= $result->user_avatar;
					break;
				case '3':
					$subpath	= $phpbbConfig->avatar_gallery_path;
					$source		= JURI::root().$this->phpbbpath.'/'.$subpath.'/'.$result->user_avatar;
					break;
				default:
					$subpath = '';
			}
			
			$dimension = EasyImageHelper::imageResize($result->user_avatar_width, $result->user_avatar_height, 60);
			$result->user_avatar_width	= $dimension[0];
			$result->user_avatar_height	= $dimension[1];
		}
		else
		{
			$sql	= 'SELECT '.$phpbbDB->nameQuote('theme_name').' '
					. 'FROM '.$phpbbDB->nameQuote('#__styles_theme').' ' 
					. 'WHERE '.$phpbbDB->nameQuote('theme_id').' = '.$phpbbDB->quote($phpbbConfig->default_style);
			$phpbbDB->setQuery($sql);
			$theme = $phpbbDB->loadObject();
			
			$defaultPath	= $this->phpbbpath.'/styles/'.$theme->theme_name.'/theme/images/no_avatar.gif';
			$source			= JURI::root().$defaultPath;
			
			$dimension	= EasyImageHelper::getAvatarDimension($defaultPath);
			$result->user_avatar_width	= $dimension[0];
			$result->user_avatar_height = $dimension[1];
		}
		
		$avatar = new stdClass();
		$avatar->link	= $source;
		$avatar->width	= $result->user_avatar_width;
		$avatar->height	= $result->user_avatar_height;
		
		return $avatar;		
	}
	
	function _getLink($profile)
	{
		$link = JURI::root().$this->phpbbpath.'memberlist.php?mode=viewprofile&u='.$this->phpbbuserid;
		return $link;
	}
	
	function _getPhpbbDBO()
	{
		static $phpbbDB = null;
        
		if($phpbbDB == null)
		{
			require( $this->files );
		
			$host		= $dbhost;
			$user		= $dbuser;
			$password	= $dbpasswd;
			$database	= $dbname;
			$prefix		= $table_prefix;
			$driver		= $dbms;
			$debug		= 0;
			
			$options = array ( 'driver' => $driver, 'host' => $host, 'user' => $user, 'password' => $password, 'database' => $database, 'prefix' => $prefix );
			
			$phpbbDB =& JDatabase::getInstance( $options );
		}
		
		return $phpbbDB;
	}
	
	function _getPhpbbConfig()
	{
		$phpbbDB = $this->_getPhpbbDBO();
		
		$sql	= 'SELECT '.$phpbbDB->nameQuote('config_name').', '.$phpbbDB->nameQuote('config_value').' '
				. 'FROM '.$phpbbDB->nameQuote('#__config') . ' '
				. 'WHERE '.$phpbbDB->nameQuote('config_name').' IN ('.$phpbbDB->quote('avatar_gallery_path').', '.$phpbbDB->quote('avatar_path').', '.$phpbbDB->quote('default_style').')';
		$phpbbDB->setQuery($sql);
		$result = $phpbbDB->loadObjectList();
		
		if(empty($result))
		{
			return false;
		}
				
		$phpbbConfig = new stdClass();
        $phpbbConfig->avatar_gallery_path	= null;
        $phpbbConfig->avatar_upload_path	= null;
		$phpbbConfig->default_style			= 1;
				
		foreach($result as $row)
		{
			switch($row->config_name)
			{
				case 'avatar_gallery_path':
					$phpbbConfig->avatar_gallery_path = $row->config_value;
					break;
				case 'avatar_path':
					$phpbbConfig->avatar_upload_path = $row->config_value;
					break;
				case 'default_style':
					$phpbbConfig->default_style = $row->config_value;
					break;
			}
		}
		
		return $phpbbConfig;
	}
}

class EasyBlogIntegrateAnahita
{
	function _init()
	{
		return false;		
	}
	
	function _getAvatar()
	{
	
	}
}
	
class EasyBlogIntegrateTuiyo
{
	function _init()
	{
		return false;		
	}
	
	function _getAvatar()
	{
	
	}
}