<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2011 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.model' );

require_once( EBLOG_HELPERS . DS . 'helper.php' );
require_once( EBLOG_HELPERS . DS . 'oauth.php' );

class EasyBlogSubscription
{
	public function getSubscriptionbyUser( $userId )
	{
		$db = JFactory::getDBO();

		$query =	"SELECT `id`, 'subscription' as `type`, `post_id` as `cid`, `user_id`, `created` FROM " . $db->nameQuote('#__easyblog_post_subscription') . " WHERE `user_id` = " . $db->Quote($userId);
		$query .= 	" UNION SELECT `id`, 'categorysubscription' as `type`, `category_id` as `cid`, `user_id`, `created` FROM " . $db->nameQuote('#__easyblog_category_subscription') . " WHERE `user_id` = " . $db->Quote($userId);
		$query .= 	" UNION SELECT `id`, 'bloggersubscription' as `type`, `blogger_id` as `cid`, `user_id`, `created` FROM " . $db->nameQuote('#__easyblog_blogger_subscription') . " WHERE `user_id` = " . $db->Quote($userId);
		$query .= 	" UNION SELECT `id`, 'teamsubscription' as `type`, `team_id` as `cid`, `user_id`, `created` FROM " . $db->nameQuote('#__easyblog_team_subscription') . " WHERE `user_id` = " . $db->Quote($userId);
		$query .= 	" UNION SELECT `id`, 'sitesubscription' as `type`, '0' as `cid`, `user_id`, `created` FROM " . $db->nameQuote('#__easyblog_site_subscription') . " WHERE `user_id` = " . $db->Quote($userId);
		$query .=	" ORDER BY `type` ";

		$db->setQuery($query);

		$subs = $db->loadObjectlist();

		if(empty($subs))
		{
			return false;
		}

		return $subs;
	}

	public function getUnsubscribeLink($subdata, $external=false)
	{
		$easyblogItemId = EasyBlogRouter::getItemId( 'latest' );
		$unsubdata = base64_encode("type=".$subdata->type."\r\nsid=".$subdata->id."\r\nuid=".$subdata->user_id."\r\ntoken=".md5($subdata->id.$subdata->created));

		return EasyBlogRouter::getRoutedURL('index.php?option=com_easyblog&controller=subscription&task=unsubscribe&data='.$unsubdata.'&Itemid=' . $easyblogItemId, false, $external);
	}

	public function blogSendToAll( $blog, $emailData )
	{
		JFactory::getLanguage()->load( 'com_easyblog' , JPATH_ROOT );

		JLoader::import( 'subscription' , EBLOG_ROOT . DS . 'models' );
		$model			=& JModel::getInstance( 'Subscription' , 'EasyBlogModel' );
		$subscribers	= $model->getMembersAndSubscribers();

		$config =& EasyBlogHelper::getConfig();
		$notify	=& EasyBlogHelper::getNotification();

		$emails = array();
		if(! empty($subscribers))
		{
			foreach($subscribers as $subscriber)
			{
				if($subscriber->type != 'member')
				{
					$unsublink  = '';
					$unsublink	= EasyBlogSubscription::getUnsubscribeLink($subscriber, true);
					$emailData['unsubscribeLink'] = JText::sprintf('EMAIL_UNSUBSCRIBE_INFO' , '<a href="'.$unsublink.'">'.JText::_('COM_EASYBLOG_URL_HERE').'</a>');
				}

				$notify->sendEmails($subscriber->email, JText::sprintf('COM_EASYBLOG_EMAIL_TITLE_NEW_BLOG_ADDED_WITH_TITLE' , JString::substr( $blog->title , 0 , 25 ) ) , '', 'email.blog.new.php', $emailData);
			}
		}

	}

	public function processNewBlogNotification( $blog, $emailData, $blogContribution )
	{
		JLoader::import( 'blogger' 		, EBLOG_ROOT . DS . 'models' );
		JLoader::import( 'category' 	, EBLOG_ROOT . DS . 'models' );
		JLoader::import( 'teamblogs' 	, EBLOG_ROOT . DS . 'models' );
		JLoader::import( 'subscription' , EBLOG_ROOT . DS . 'models' );

		JFactory::getLanguage()->load( 'com_easyblog' , JPATH_ROOT );

		$config =& EasyBlogHelper::getConfig();
		$notify	=& EasyBlogHelper::getNotification();

		//send notification to all blogger's subscribers
		if($config->get('notification_blogsubscriber'))
		{
			$modelBlogger		=& JModel::getInstance( 'Blogger' , 'EasyBlogModel' );
			$subscribers		= $modelBlogger->getBlogggerSubscribers($blog->created_by);

			$emails = array();
			if(! empty($subscribers))
			{
				foreach($subscribers as $subscriber)
				{
					$unsublink = EasyBlogSubscription::getUnsubscribeLink($subscriber, true);
					$emailData['unsubscribeLink'] = JText::sprintf('EMAIL_UNSUBSCRIBE_INFO' , '<a href="'.$unsublink.'">'.JText::_('COM_EASYBLOG_URL_HERE').'</a>');

					$notify->sendEmails($subscriber->email, JText::sprintf('COM_EASYBLOG_EMAIL_TITLE_NEW_BLOG_ADDED_WITH_TITLE' , JString::substr( $blog->title , 0 , 25 ) ) , '', 'email.blog.new.php', $emailData);
				}
			}
		}

		//send notification to all category's subscribers
		if($config->get('notification_categorysubscriber'))
		{

			$modelCategory		=& JModel::getInstance( 'Category' , 'EasyBlogModel' );
			$subscribers		= $modelCategory->getCategorySubscribers($blog->category_id);

			$emails = array();
			if(! empty($subscribers))
			{
				foreach($subscribers as $subscriber)
				{
					$unsublink	= EasyBlogSubscription::getUnsubscribeLink($subscriber, true);
					$emailData['unsubscribeLink'] = JText::sprintf('EMAIL_UNSUBSCRIBE_INFO' , '<a href="'.$unsublink.'">'.JText::_('COM_EASYBLOG_URL_HERE').'</a>');

					$emails[]	= $subscriber->email;
					$notify->sendEmails($subscriber->email, JText::sprintf('COM_EASYBLOG_EMAIL_TITLE_NEW_BLOG_ADDED_WITH_TITLE' , JString::substr( $blog->title , 0 , 25 ) ), '', 'email.blog.new.php', $emailData);
				}
			}
		}

		//send notification to all team's subscribers
		if($config->get('notification_teamsubscriber'))
		{
			$modelTeam		=& JModel::getInstance( 'TeamBlogs' , 'EasyBlogModel' );

			$blogContribution	= (array) $blogContribution;
			if(!empty($blogContribution))
			{
				foreach($blogContribution as $teamId)
				{
					$subscribers	= $modelTeam->getTeamSubscribers($teamId);

					$emails = array();
					if(! empty($subscribers))
					{
						foreach($subscribers as $subscriber)
						{
							$unsublink	= EasyBlogSubscription::getUnsubscribeLink($subscriber, true);
							$emailData['unsubscribeLink'] = JText::sprintf('EMAIL_UNSUBSCRIBE_INFO' , '<a href="'.$unsublink.'">'.JText::_('COM_EASYBLOG_URL_HERE').'</a>');

							$notify->sendEmails($subscriber->email, JText::sprintf('COM_EASYBLOG_EMAIL_TITLE_NEW_BLOG_ADDED_WITH_TITLE' , JString::substr( $blog->title , 0 , 25 ) ) , '', 'email.blog.new.php', $emailData);
						}
					}
				}
			}
		}

		//send notification to all site's subscribers
		if($config->get('notification_sitesubscriber'))
		{
			$modelSiteSubscribe		=& JModel::getInstance( 'Subscription' , 'EasyBlogModel' );

			$subscribers        	= $modelSiteSubscribe->getSiteSubscribers();

			$emails = array();
			if(! empty($subscribers))
			{
				foreach($subscribers as $subscriber)
				{
					$unsublink	= EasyBlogSubscription::getUnsubscribeLink($subscriber, true);
					$emailData['unsubscribeLink'] = JText::sprintf('EMAIL_UNSUBSCRIBE_INFO' , '<a href="'.$unsublink.'">'.JText::_('COM_EASYBLOG_URL_HERE').'</a>');

					$notify->sendEmails($subscriber->email, JText::sprintf('COM_EASYBLOG_EMAIL_TITLE_NEW_BLOG_ADDED_WITH_TITLE' , JString::substr( $blog->title , 0 , 25 ) ) , '', 'email.blog.new.php', $emailData);
				}
			}
		}

		return true;
	}

}
