<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

require_once( JPATH_ROOT.DS.'components'.DS.'com_easyblog'.DS.'constants.php' );
require_once( EBLOG_HELPERS . DS . 'helper.php' );
require_once( EBLOG_HELPERS . DS . 'router.php' );

/**
 * Content Component Article Model
 *
 * @package		Joomla
 * @subpackage	Content
 * @since 1.5
 */
class EasyBlogModelBlog extends JModel
{

	/**
	 * Record total
	 *
	 * @var integer
	 */
	var $_total = null;

	/**
	 * Pagination object
	 *
	 * @var object
	 */
	var $_pagination = null;

	/**
	 * Constructor
	 *
	 * @since 1.5
	 */
	function __construct()
	{
		parent::__construct();

		$mainframe	= JFactory::getApplication();

		$limit		= ($mainframe->getCfg('list_limit') == 0) ? 5 : $mainframe->getCfg('list_limit');
	    $limitstart = JRequest::getVar('limitstart', 0, 'REQUEST');

		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
	}

	function getBlogComment( $blogId, $limistFrontEnd = 0, $sort = 'asc', $isLite = false )
	{
		$db	= JFactory::getDBO();

		if( $isLite )
		{
            $query  = 'SELECT a.* FROM `#__easyblog_comment` a';
			$query	.= ' WHERE a.`post_id` = '.$db->Quote($blogId);
			$query	.= ' AND a.`published` = 1';
		}
		else
		{
			$query	= 'SELECT a.*, (count(b.id) - 1) AS `depth` FROM `#__easyblog_comment` a,';
			$query	.= ' `#__easyblog_comment` b';
			$query	.= ' WHERE a.`post_id` = '.$db->Quote($blogId);
			$query	.= ' AND b.`post_id` = '.$db->Quote($blogId);
			$query	.= ' AND a.`published` = 1';
			$query	.= ' AND b.`published` = 1';
			$query	.= ' AND a.`lft` BETWEEN b.`lft` AND b.`rgt`';
			$query	.= ' GROUP BY a.`id`';
		}

		// prepare the query to get total comment
		$queryTotal  	= 'SELECT COUNT(1) FROM (';
		$queryTotal		.= $query;
		$queryTotal		.= ') AS x';

		// continue the query.
		$limit		= $this->getState('limit');
		$limitstart = $this->getState('limitstart');

		if( $sort == 'desc' )
   			$query	.= ' ORDER BY a.`rgt` desc';
		else
			$query	.= ' ORDER BY a.`lft` asc';

		if($limistFrontEnd > 0)
		{
			$query  .= ' LIMIT ' . $limistFrontEnd;
		}
		else
		{
		    $query  .= ' LIMIT ' . $limitstart . ',' . $limit;
		}

        if($limistFrontEnd <= 0)
		{
			$db->setQuery( $queryTotal );
			$this->_total	= $db->loadResult();

			jimport('joomla.html.pagination');
			$this->_pagination	= new JPagination( $this->_total , $limitstart , $limit);
		}

		// the actual content sql
		$db->setQuery($query);
		if($db->getErrorNum() > 0)
		{
			JError::raiseError( $db->getErrorNum() , $db->getErrorMsg() . $db->stderr());
		}

		$result	= $db->loadObjectList();

		if( !$result )
		{
			return $result;
		}

		// Format the comments
		$result	= EasyBlogHelper::getHelper( 'Comment' )->format( $result );

		return $result;
	}

	function getFeaturedBlog( $categories = array() , $limit = null )
	{
		$my 	= JFactory::getUser();
	    $db 	= JFactory::getDBO();
	    $max	= is_null( $limit ) ? EBLOG_MAX_FEATURED_POST : $limit;

	    $isBloggerMode  = EasyBlogRouter::isBloggerMode();

	    $queryExclude   = '';
		$excludeCats	= array();

		// get all private categories id
		$excludeCats	= EasyBlogHelper::getPrivateCategories();

		if(! empty($excludeCats))
		{
		    $queryExclude .= ' AND a.`category_id` NOT IN (' . implode(',', $excludeCats) . ')';
		}


		$query	 = 'SELECT a.*, b.`title` AS `category` FROM `#__easyblog_post` AS a';
		$query	.= ' LEFT JOIN `#__easyblog_category` AS b';
		$query	.= ' 	ON a.category_id = b.id';
		$query	.= ' INNER JOIN `#__easyblog_featured` AS c';
		$query	.= ' 	ON a.`id` = c.`content_id` AND c.`type` = ' . $db->Quote('post');
		$query	.= ' WHERE a.`published` = 1';

		if($isBloggerMode !== false)
		{
		    $query  .= ' AND a.`created_by` = ' . $db->Quote($isBloggerMode);
		}

		// @rule: Explicitly include posts only from these categories
		if( !empty( $categories ) )
		{
			// To support both comma separated categories an array of categories
			if( !is_array( $categories ) )
			{
				$categories	= explode( ',' , $categories );
			}

		    $total  = count( $categories );
		    $query  .= ' AND a.`category_id` IN (';
		    for( $i = 0; $i < $total; $i++ )
		    {
		        $query  .= $db->Quote( $categories[ $i ] );

		        if( ( $i + 1 )!= $total )
		        {
		            $query  .= ',';
				}
			}
			$query  .= ')';
		}
		$query  .= $queryExclude;

		//blog privacy setting
		if($my->id == 0)
		    $query .= ' AND a.`private` = ' . $db->Quote(BLOG_PRIVACY_PUBLIC);

		$query	.= ' ORDER BY a.`created` DESC';
		if($max > 0)
		    $query  .= ' LIMIT ' . $max;

		$db->setQuery($query);

		$result = $db->loadObjectList();

		return $result;
	}

	public function getDrafts( $userId )
	{
		$db		= JFactory::getDBO();
		$query	= 'SELECT * FROM ' . $db->nameQuote( '#__easyblog_drafts' ) . ' '
				. 'WHERE ' . $db->nameQuote( 'created_by' ) . '=' . $db->Quote( $userId );
		$db->setQuery( $query );

		$result	= $db->loadObjectList();
	}

	/**
	 * Get array of blogs defined by parameters
	 *
	 * @param	$type			str
	 * @param	$typeId			int
	 * @param	$sort			str
	 * @param	$max			int
	 * @param	$published		str
	 * @param	$search			bool
	 * @param	$frontpage		bool
	 * @param	$excludeBlogs	array
	 * @param	$pending		bool
	 * @param	$dashboard		bool
	 * @param	$protected		bool
	 * @param	$excludeCats	array
	 * @param	$includeCats	array
	 *
	*/
	function getBlogsBy( $type, $typeId = 0, $sort = '', $max = 0 , $published = EBLOG_FILTER_PUBLISHED , $search = false, $frontpage = false, $excludeBlogs	= array(), $pending = false, $dashboard = false, $protected = true , $excludeCats = array() , $includeCats = array() )
	{
		$db		= JFactory::getDBO();
		$my 	= JFactory::getUser();
		$config	= EasyBlogHelper::getConfig();

		$queryPagination		= false;
		$queryWhere				= '';
		$queryOrder				= '';
		$queryLimit				= '';
		$queryWhere				= '';
		$queryExclude			= '';
		$queryExcludePending    = '';
		$queryExcludePrivateJSGrp    = '';


		$excludeCats			= !empty( $excludeCats ) ? $excludeCats : array();

		$isBloggerMode  = EasyBlogRouter::isBloggerMode();
		$teamBlogIds    = '';

		$sort           = ( empty( $sort ) ) ? $config->get( 'layout_postorder', 'latest' ) : $sort;


		$isJSGrpPluginInstalled = false;
		$isJSGrpPluginInstalled = JPluginHelper::isEnabled('system', 'groupeasyblog');
		$isJSInstalled          = false; // need to check if the site installed jomsocial.

		if(JFile::exists(JPATH_ROOT . DS . 'components' . DS. 'com_community' . DS . 'libraries' . DS .'core.php'))
		{
			$isJSInstalled = true;
		}


		$includeJSGrp           = ($type != 'teamblog' && !$dashboard && $isJSGrpPluginInstalled && $isJSInstalled) ? true : false;
		$jsGrpPostIds           = '';

		if( $includeJSGrp )
		{
			$queryJSGrp = 'select `post_id` from `#__easyblog_external_groups` as exg inner join `#__community_groups` as jsg';
			$queryJSGrp .= '      on exg.group_id = jsg.id ';
			$queryJSGrp .= '      where jsg.`approvals` = 0';

			$db->setQuery($queryJSGrp);
			$jsGrpPostIds   = $db->loadResultArray();

			if( !empty( $excludeBlogs ) && !empty( $jsGrpPostIds ) )
			{
				$jsGrpPostIds   = array_diff($jsGrpPostIds, $excludeBlogs);
			}
		}


	    //get teamblogs id.
	    $query  = '';
	    if( $config->get( 'main_includeteamblogpost' ) || $dashboard )
	    {
			$teamBlogIds	= EasyBlogHelper::getViewableTeamIds();
			if( count( $teamBlogIds ) > 0 )
            	$teamBlogIds    = implode( ',' , $teamBlogIds);
	    }

		// get all private categories id
		$excludeCats	= EasyBlogHelper::getPrivateCategories();

		//check if the request come with statastic or not.
        $statType	= JRequest::getString('stat','');
        $statId     = '';
		if($statType != '')
		{
			$statId = ($statType == 'tag') ? JRequest::getString('tagid','') : JRequest::getString('catid','');
		}

		if(! empty($excludeBlogs))
		{
			$queryExclude .= ' AND a.`id` NOT IN (';
		    for( $i = 0; $i < count( $excludeBlogs ); $i++ )
		    {
		    	$queryExclude	.= $db->Quote( $excludeBlogs[ $i ] );

		    	if( next( $excludeBlogs ) !== false )
		    	{
		    		$queryExclude .= ',';
				}
			}
			$queryExclude	.= ')';
		}

		if(! empty($excludeCats))
		{
		    $queryExclude .= ' AND a.`category_id` NOT IN (';

		    for( $i = 0; $i < count( $excludeCats ); $i++ )
		    {
		    	$queryExclude	.= $db->Quote( $excludeCats[ $i ] );

		    	if( next( $excludeCats ) !== false )
		    	{
		    		$queryExclude .= ',';
				}
			}
			$queryExclude	.= ')';
		}

		$queryInclude	= '';

		// Respect inclusion categories
		if( !empty( $includeCats ) )
		{
			$queryInclude	= ' AND a.`category_id` IN(';

			if( !is_array( $includeCats ) )
			{
				$includeCats	= array( $includeCats );
			}

			for( $i = 0; $i < count( $includeCats ); $i++ )
			{
				$queryInclude	.= $db->Quote( $includeCats[ $i ] );

				if( next( $includeCats ) !== false )
				{
					$queryInclude	.= ',';
				}
			}
			$queryInclude	.= ')';
		}

		switch( $published )
		{
			case EBLOG_FILTER_PENDING:
				$queryWhere	= ' WHERE a.`ispending` = 1 AND a.`published` != 3';
				break;
			case EBLOG_FILTER_ALL:
				$queryWhere	= ' WHERE (a.`published` = 1 OR a.`published`=0 OR a.`published`=2 OR a.`published`=3) ';
				break;
			case EBLOG_FILTER_SCHEDULE:
				$queryWhere	= ' WHERE a.`published` = 2 AND a.`ispending` = ' . $db->Quote('0');
				break;
			case EBLOG_FILTER_UNPUBLISHED:
				$queryWhere	= ' WHERE a.`published` = 0 AND a.`ispending` = ' . $db->Quote('0');
				break;
			case EBLOG_FILTER_DRAFT:
				$queryWhere	= ' WHERE a.`published` = 3 ';
				break;
			case EBLOG_FILTER_PUBLISHED:
			default:
				$queryWhere	= ' WHERE a.`published` = 1 AND a.`ispending` = ' . $db->Quote('0');
				break;
		}

		//do not list out protected blog in rss
		if(JRequest::getCmd('format', '') == 'feed')
		{
			if($config->get('main_password_protect', true))
			{
				$queryWhere	.= ' AND a.`blogpassword`="" ';
			}
		}

		//blog privacy setting
		// @integrations: jomsocial privacy
		$file		= JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php';

		if( $config->get( 'main_jomsocial_privacy' ) && JFile::exists( $file ) && !EasyBlogHelper::isSiteAdmin() && $type != 'teamblog' && !$dashboard)
		{
			require_once( $file );

			$my			= JFactory::getUser();
			$jsFriends	= CFactory::getModel( 'Friends' );
			$friends	= $jsFriends->getFriendIds( $my->id );
			array_push($friends, $my->id);

			// Insert query here.
			$queryWhere	.= ' AND (';
			$queryWhere	.= ' (a.`private`= 0 ) OR';
			$queryWhere	.= ' ( (a.`private` = 20) AND (' . $db->Quote( $my->id ) . ' > 0 ) ) OR';

			if( empty( $friends ) )
			{
				$queryWhere	.= ' ( (a.`private` = 30) AND ( 1 = 2 ) ) OR';
			}
			else
			{
				$queryWhere	.= ' ( (a.`private` = 30) AND ( a.' . $db->nameQuote( 'created_by' ) . ' IN (' . implode( ',' , $friends ) . ') ) ) OR';
			}

			$queryWhere	.= ' ( (a.`private` = 40) AND ( a.' . $db->nameQuote( 'created_by' ) .'=' . $my->id . ') )';
			$queryWhere	.= ' )';
		}
		else
		{
			if( $my->id == 0)
			{
				$queryWhere .= ' AND a.`private` = ' . $db->Quote(BLOG_PRIVACY_PUBLIC);
			}
		}

		if($isBloggerMode !== false)
		{
		    $queryWhere .= ' AND a.`created_by` = ' . $db->Quote($isBloggerMode);
		}

		$contentId  = '';
		$isIdArray  = false;
		if(is_array($typeId))
		{
		    if(count($typeId) > 1)
		    {
		    	for( $i = 0; $i < count($typeId ); $i++ )
		    	{
		    		if( $typeId[ $i ] )
		    		{
		    			$contentId	.= $typeId[ $i ];

		    			if( $i + 1 < count($typeId) )
		    			{
		    				$contentId .= ',';
		    			}
		    		}
		    	}
			    $isIdArray  = true;
		    }
		    else
		    {
		        $contentId	= $typeId[0];
		    }
		}
		else
		{
		    $contentId  = $typeId;
		}

		switch( $type )
		{
			case 'category':
				$queryWhere	.= ($isIdArray) ? ' AND a.`category_id` IN ('. $contentId .')' : ' AND a.`category_id` = ' . $db->Quote($contentId);

				if($isBloggerMode === false)
				{
		    		$catBloggerId   = EasyBlogHelper::getCategoryMenuBloggerId();
		    		if( !empty($catBloggerId) )
		    		{
		    		    $queryWhere	.= ' AND a.`created_by` = ' . $db->Quote($catBloggerId);
		    		}
	    		}

				break;
			case 'blogger':
				$queryWhere	.= ($isIdArray) ? ' AND a.`created_by` IN ('. $contentId .')' : ' AND a.`created_by` = ' . $db->Quote($contentId);
				break;
			case 'teamblog':
				$queryWhere	.= ($isIdArray) ? ' AND u.`team_id` IN ('. $contentId .')' : ' AND u.`team_id` = ' . $db->Quote($contentId);
				break;
			default :
				break;
		}

		if($type == 'blogger' || $type == 'teamblog')
		{
			if(! empty($statType))
			{
				if($statType == 'category')
				    $queryWhere	.= ' AND a.`category_id` = ' . $db->Quote($statId);
				else
					$queryWhere	.= ' AND t.`tag_id` = ' . $db->Quote($statId);
			}
		}

		if( $search )
		{
			$queryWhere	.= ' AND a.`title` LIKE ' . $db->Quote( '%' . $search . '%' );
		}

		if( $frontpage )
		{
		    $queryWhere	.= ' AND a.`frontpage` = ' . $db->Quote('1');
		}


		if( $type != 'teamblog' && !$dashboard )
		{
		    if( $config->get( 'main_includeteamblogpost' ) && !empty($teamBlogIds) )
		    {
				if( !empty( $jsGrpPostIds ) )
				{
					$tmpIds = implode( ',', $jsGrpPostIds);
					$queryWhere	.= ' AND (u.team_id IN ('.$teamBlogIds.') OR a.id IN (' . $tmpIds . ') OR a.`issitewide` = ' . $db->Quote('1') . ')';
				}
				else
				{
					$queryWhere	.= ' AND (u.team_id IN ('.$teamBlogIds.') OR a.`issitewide` = ' . $db->Quote('1') . ')';
				}
			}
			else
			{
				if( $jsGrpPostIds )
				{
					$tmpIds = implode( ',', $jsGrpPostIds);
					$queryWhere	.= ' AND ( a.`issitewide` = 1 OR a.id IN (' . $tmpIds . ') )';
				}
				else
				{
			    	$queryWhere	.= ' AND a.`issitewide` = ' . $db->Quote('1');
				}
			}
		}

		if($protected == false)
		{
			$queryWhere	.= ' AND a.`blogpassword` = ""';
		}

		// get the default sorting.
		$defaultSorting = $config->get( 'layout_postsort', 'desc' );

		switch( $sort )
		{
			case 'latest':
				$queryOrder	= ' ORDER BY a.`created` ' . $defaultSorting;
				break;
			case 'popular':
				$queryOrder	= ' ORDER BY a.`hits` ' . $defaultSorting;
				break;
			case 'active':
				$queryOrder	= ' ORDER BY a.`publish_down` ' . $defaultSorting;
				break;
			case 'alphabet':
				$queryOrder	= ' ORDER BY a.`title` ' . $defaultSorting;
				break;
			case 'modified':
				$queryOrder	= ' ORDER BY a.`modified` ' . $defaultSorting;
				break;
			case 'random':
				$queryOrder	= ' ORDER BY RAND() ';
				break;
			default :
				break;
		}

		if($max > 0)
		{
			$queryLimit	= ' LIMIT '.$max;
		}
		else
		{
			$limit		= $this->getState('limit');
			$limitstart = $this->getState('limitstart');

			//set frontpage list length if it is detected to be the frontpage
			$view		= JRequest::getCmd('view', '');

			$limit		= EasyBlogHelper::getHelper( 'Pagination' )->getLimit();
			$limitstart = JRequest::getVar('limitstart', 0, 'REQUEST');

			// In case limit has been changed, adjust it
			$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

			$queryLimit	= ' LIMIT ' . $limitstart . ',' . $limit;

			$queryPagination = true;
		}

		$excludePendingPost = '';
		if( $dashboard )
			$excludePendingPost = ' and not exists ( select `entry_id` from `#__easyblog_drafts` as ed where ed.`entry_id` = a.`id` and pending_approval = 1 )';

		if($queryPagination)
		{
			$query	= 'SELECT COUNT(1) FROM `#__easyblog_post` AS a';

			if($type == 'teamblog' || ( ( $config->get( 'main_includeteamblogpost' ) || $dashboard ) && !empty($teamBlogIds) ))
			{
			    $query  .= ' LEFT JOIN `#__easyblog_team_post` AS u ON a.id = u.post_id';
			}

			if( ($type == 'blogger' || $type == 'teamblog') && $statType == 'tag')
			{
			    $query  .= ' LEFT JOIN `#__easyblog_post_tag` AS t ON a.id = t.post_id';
			    //$query  .= ' AND t.`tag_id` = ' . $db->Quote($statId);
			}
			$query	.= $queryWhere;
			$query	.= $queryExclude;
			$query	.= $queryInclude;
			$query  .= $excludePendingPost;

			$db->setQuery( $query );
			$this->_total	= $db->loadResult();

			jimport('joomla.html.pagination');
			$this->_pagination	= new JPagination( $this->_total , $limitstart , $limit);
		}


		$query	= 'SELECT a.`id` AS key1, a.*, b.`id` as key2, b.`title` as `category`';
		if( ($type == 'teamblog' || $config->get( 'main_includeteamblogpost' ) || $dashboard ) && !empty($teamBlogIds) )
		    $query  .= ' ,u.`team_id` ';

		$query .= ' FROM `#__easyblog_post` AS a';
		$query .= ' LEFT JOIN `#__easyblog_category` AS b';
		$query .= ' ON a.category_id = b.id';


		if( $type == 'teamblog' || ( ( $config->get( 'main_includeteamblogpost' ) || $dashboard ) && !empty($teamBlogIds) ) )
		{
		    $query  .= ' LEFT JOIN `#__easyblog_team_post` AS u ON a.id = u.post_id';
		}

		if( ($type == 'blogger' || $type == 'teamblog') && $statType == 'tag')
		{
		    $query  .= ' LEFT JOIN `#__easyblog_post_tag` AS t ON a.`id` = t.`post_id`';
		    $query  .= ' AND t.`tag_id` = ' . $db->Quote($statId);
		}


		$query .= $queryWhere;
		$query .= $queryExclude;
		$query	.= $queryInclude;
		$query  .= $excludePendingPost;
		$query .= $queryOrder;
		$query .= $queryLimit;

// 		echo $query;
// 		echo '<br><br>';


		$db->setQuery($query);

		if($db->getErrorNum() > 0)
		{
			JError::raiseError( $db->getErrorNum() , $db->getErrorMsg() . $db->stderr());
		}

		$result	= $db->loadObjectList();
		return $result;
	}


	function getPending( $typeId = 0, $sort = 'latest', $max = 0 , $search = false, $frontpage = false )
	{
		$db	= JFactory::getDBO();

		$queryPagination	= false;
		$queryWhere		= '';
		$queryOrder		= '';
		$queryLimit		= '';
		$queryWhere		= '';
		$queryExclude	= '';

		$queryWhere	.= ' WHERE a.`pending_approval` = ' . $db->Quote('1');

		if( $search )
		{
			$queryWhere	.= ' AND a.`title` LIKE ' . $db->Quote( '%' . $search . '%' );
		}

		if( ! empty( $typeId ) )
		{
		    $queryWhere	.= ' AND a.`created_by` = ' . $db->Quote( $typeId );
		}

		switch( $sort )
		{
			case 'latest':
				$queryOrder	= ' ORDER BY a.`created` DESC';
				break;
			case 'popular':
				$queryOrder	= ' ORDER BY a.`hits` DESC';
				break;
			case 'active':
				$queryOrder	= ' ORDER BY a.`publish_down` DESC';
				break;
			case 'alphabet':
				$queryOrder	= ' ORDER BY a.`title` ASC';
				break;
			default :
				break;
		}

		if($max > 0)
		{
			$queryLimit	= ' LIMIT '.$max;
		}
		else
		{
			$limit		= $this->getState('limit');
			$limitstart = $this->getState('limitstart');

			//set frontpage list length if it is detected to be the frontpage
			$view		= JRequest::getCmd('view', '');
			if($view=='latest')
			{
				$config		= EasyBlogHelper::getConfig();
				$listlength = $config->get('layout_listlength', '0');
				if($listlength)
				{
					$limit = $listlength;
					$limitstart = JRequest::getVar('limitstart', 0, 'REQUEST');
					// In case limit has been changed, adjust it
					$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
				}
			}

			$queryLimit	= ' LIMIT ' . $limitstart . ',' . $limit;

			$queryPagination = true;
		}

		if($queryPagination)
		{
			$query	= 'SELECT COUNT(1) FROM `#__easyblog_drafts` AS a';

			$query	.= $queryWhere;
			$query	.= $queryExclude;

			$db->setQuery( $query );
			$this->_total	= $db->loadResult();

			jimport('joomla.html.pagination');
			$this->_pagination	= new JPagination( $this->_total , $limitstart , $limit);
		}


		$query	= 'SELECT a.*, b.`title` AS `category` FROM `#__easyblog_drafts` AS a';
		$query .= ' LEFT JOIN `#__easyblog_category` AS b';
		$query .= ' ON a.category_id = b.id';

		$query .= $queryWhere;
		$query .= $queryExclude;
		$query .= $queryOrder;
		$query .= $queryLimit;

		//echo $query;

		$db->setQuery($query);
		if($db->getErrorNum() > 0)
		{
			JError::raiseError( $db->getErrorNum() , $db->getErrorMsg() . $db->stderr());
		}

		$result	= $db->loadObjectList();
		return $result;
	}


	/**
	 * Method to get a pagination object for the categories
	 *
	 * @access public
	 * @return integer
	 */
	function getPagination()
	{
		return $this->_pagination;
	}

	/**
	 * Method to get a pagination object for the categories
	 *
	 * @access public
	 * @return integer
	 */
	function getTotal()
	{
		return $this->_total;
	}

	/**
	 * Method to get total blogs post currently iregardless the status.
	 *
	 * @access public
	 * @return integer
	 */
	function getTotalBlogs( $userId	= 0 )
	{
		$db		= $this->getDBO();
		$where	= array();

		$query	= 'SELECT COUNT(1) FROM ' . $db->nameQuote( '#__easyblog_post' );

		//blog privacy setting
		$my = JFactory::getUser();
		if($my->id == 0)
		    $where[] = '`private` = ' . $db->Quote(BLOG_PRIVACY_PUBLIC);

		if(! empty($userId) )
		    $where[] = '`created_by` = ' . $db->Quote($userId);

		$extra 		= ( count( $where ) ? ' WHERE ' . implode( ' AND ', $where ) : '' );

		$query      = $query . $extra;

		$db->setQuery( $query );

		$result	= $db->loadResult();

		return (empty($result)) ? 0 : $result;
	}

	function getTotalBlogSubscribers( $userId = 0 )
	{
		$db		= $this->getDBO();
		$where	= array();

		$query	= 'select count(1) from `#__easyblog_post_subscription` as a';
		$query	.= '  inner join `#__easyblog_post` as b';
		$query	.= '    on a.post_id = b.id';
		if(! empty($userId))
		$query	.= '    and b.created_by = ' . $db->Quote($userId);

		$db->setQuery( $query );
		$result	= $db->loadResult();

		return (empty($result)) ? 0 : $result;
	}

	/**
	 * Method to retrieve blog posts based on the given tag id.
	 *
	 * @access public
	 * @param	int		$tagId	The tag id.
	 * @return	array	$rows	An array of blog objects.
	 */
	function getTaggedBlogs( $tagId = 0 , $limit = false, $includeCatIds = '' )
	{
		if( $tagId ==  0 )
			return false;

		$my 		= JFactory::getUser();
		$db			= $this->getDBO();
		$config     = EasyBlogHelper::getConfig();

		$limit		= $limit === false ? $this->getState('limit') : $limit;
		$limitstart = $this->getState('limitstart');

		$isBloggerMode  = EasyBlogRouter::isBloggerMode();
	    $queryExclude   = '';
		$excludeCats	= array();

	    //get teamblogs id.
	    if( $config->get( 'main_includeteamblogpost' ) )
	    {
			$teamBlogIds	= EasyBlogHelper::getViewableTeamIds();
			if( count( $teamBlogIds ) > 0 )
            	$teamBlogIds    = implode( ',' , $teamBlogIds);
	    }

		// get all private categories id
		$excludeCats	= EasyBlogHelper::getPrivateCategories();

		if(! empty($excludeCats))
		{
		    $queryExclude .= ' AND b.`category_id` NOT IN (' . implode(',', $excludeCats) . ')';
		}

		$query	= 'SELECT b.* ';

		if($config->get( 'main_includeteamblogpost' ) && !empty($teamBlogIds) )
			$query  .= ' ,u.`team_id`';

		$query	.= ' FROM ' . $db->nameQuote( '#__easyblog_post_tag' ) . ' AS a ';
		$query	.= ' INNER JOIN ' . $db->nameQuote( '#__easyblog_post' ) . ' AS b ';
		$query	.= ' ON a.post_id=b.id ';

		if($config->get( 'main_includeteamblogpost' ) && !empty($teamBlogIds) )
		{
		    $query  .= ' LEFT JOIN `#__easyblog_team_post` AS u ON b.id = u.post_id';
		}


		$query	.= ' WHERE a.tag_id = ' . $db->Quote( $tagId );
		$query	.= ' AND b.`published` = ' . $db->Quote('1');

		$file	= JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php';
 		//blog privacy setting
		if( $config->get( 'main_jomsocial_privacy' ) && JFile::exists( $file ) && !EasyBlogHelper::isSiteAdmin())
		{
			require_once( $file );

			$jsFriends	= CFactory::getModel( 'Friends' );
			$friends	= $jsFriends->getFriendIds( $my->id );
			array_push($friends, $my->id);

			// Insert query here.
			$query	.= ' AND (';
			$query	.= ' (b.`private`= 0 ) OR';
			$query	.= ' ( (b.`private` = 20) AND (' . $db->Quote( $my->id ) . ' > 0 ) ) OR';

			if( empty( $friends ) )
			{
				$query	.= ' ( (b.`private` = 30) AND ( 1 = 2 ) ) OR';
			}
			else
			{
				$query	.= ' ( (b.`private` = 30) AND ( b.' . $db->nameQuote( 'created_by' ) . ' IN (' . implode( ',' , $friends ) . ') ) ) OR';
			}

			$query	.= ' ( (b.`private` = 40) AND ( b.' . $db->nameQuote( 'created_by' ) .'=' . $my->id . ') )';
			$query	.= ' )';
		}
		else
		{
			if( $my->id == 0)
			{
				$query .= ' AND b.`private` = ' . $db->Quote(BLOG_PRIVACY_PUBLIC);
			}
		}


		if($isBloggerMode !== false)
            $query .= ' AND b.`created_by` = ' . $db->Quote($isBloggerMode);


	    if( $config->get( 'main_includeteamblogpost' ) && !empty($teamBlogIds))
	    {
			$query	.= ' AND (u.team_id IN ('.$teamBlogIds.') OR b.`issitewide` = ' . $db->Quote('1') . ')';
		}
		else
		{
		    $query	.= ' AND b.`issitewide` = ' . $db->Quote('1');
		}

		$includeCats	= array();
		$includeCatIds  = trim( $includeCatIds );
		if( !empty( $includeCatIds) )
		{
		    $includeCats = explode( ',' , $includeCatIds );

		    if( !empty($excludeCats) )
		    {
		        $includeCats    = array_diff($includeCats, $excludeCats);
		    }

		    if( !empty( $includeCats ) )
		    {
		        $query .= ' AND b.`category_id` IN (' . implode(',', $includeCats) . ')';
		    }
		}


		$query	.= $queryExclude;
		$query  .= ' ORDER BY `created` DESC';


		//total tag's post sql
		$totalQuery = 'SELECT COUNT(1) FROM (';
		$totalQuery .= $query;
		$totalQuery .= ') as x';



		$query	.= ' LIMIT ' . $limitstart . ',' . $limit;

		// echo $query . '<br><br>';

		$db->setQuery( $query );
		$rows	= $db->loadObjectList();



		// Get the pagination for the current object.
// 		$query	= 'SELECT COUNT(1) FROM ' . $db->nameQuote( '#__easyblog_post_tag' ) . ' '
// 				. 'WHERE ' . $db->nameQuote( 'tag_id' ) . '=' . $db->Quote( $tagId );
		//echo $totalQuery;

		$db->setQuery( $totalQuery );

		$db->loadResult();
		$this->_total	= $db->loadResult();

		jimport('joomla.html.pagination');
		$this->_pagination	= new JPagination( $this->_total , $limitstart , $limit);

		return $rows;
	}


    function isBlogSubscribedUser($blogId, $userId, $email)
    {
		$db	= $this->getDBO();

        $query  = 'SELECT `id` FROM `#__easyblog_post_subscription`';
        $query  .= ' WHERE `post_id` = ' . $db->Quote($blogId);
        $query  .= ' AND (`user_id` = ' . $db->Quote($userId);
		$query  .= ' OR `email` = ' . $db->Quote($email) .')';

        $db->setQuery($query);
        $result = $db->loadResult();

        return $result;
    }

    function isBlogSubscribedEmail($blogId, $email)
    {
		$db	= $this->getDBO();

        $query  = 'SELECT `id` FROM `#__easyblog_post_subscription`';
        $query  .= ' WHERE `post_id` = ' . $db->Quote($blogId);
        $query  .= ' AND `email` = ' . $db->Quote($email);

        $db->setQuery($query);
        $result = $db->loadResult();

        return $result;
    }

    function addBlogSubscription($blogId, $email, $userId = '0', $fullname = '')
    {
    	$config = EasyBlogHelper::getConfig();
    	$acl = EasyBlogACLHelper::getRuleSet();
		$my = JFactory::getUser();

		if($acl->rules->allow_subscription || (empty($my->id) && $config->get('main_allowguestsubscribe')))
		{
    		$date       = JFactory::getDate();
			$subscriber = EasyBlogHelper::getTable( 'Subscription', 'Table' );

	        $subscriber->post_id  = $blogId;
	        $subscriber->email    = $email;
	        if($userId != '0')
	            $subscriber->user_id    = $userId;

	        $subscriber->fullname   = $fullname;
	        $subscriber->created  = $date->toMySQL();
	        $subscriber->store();
    	}
    }

    function updateBlogSubscriptionEmail($sid, $userid, $email)
    {
    	$config = EasyBlogHelper::getConfig();
    	$acl = EasyBlogACLHelper::getRuleSet();
		$my = JFactory::getUser();

		if($acl->rules->allow_subscription || (empty($my->id) && $config->get('main_allowguestsubscribe')))
		{
			$subscriber = EasyBlogHelper::getTable( 'Subscription', 'Table' );
	        $subscriber->load($sid);
	        $subscriber->user_id  = $userid;
	        $subscriber->email    = $email;
	        $subscriber->store();
	    }
    }

    function getCategoryName( $category_id )
    {
        $db = JFactory::getDBO();

        if($category_id == 0)
            return JText::_('COM_EASYBLOG_UNCATEGORIZED');

    	$query  = 'SELECT `title`, `id` FROM `#__easyblog_category` WHERE `id` = ' . $db->Quote($category_id);
        $db->setQuery($query);

		$result = $db->loadResult();
        return $result;
    }

    function getTrackback( $blogId )
    {
        $db = JFactory::getDBO();

		$query  = 'SELECT * FROM `#__easyblog_trackback`';
		$query  .= ' WHERE `post_id` = ' . $db->Quote($blogId);
        $query  .= ' ORDER BY `created` DESC';

        $db->setQuery($query);
        $result = $db->loadObjectList();

        return $result;
    }

    function getRelatedBlog( $blogId, $max	= 0 )
    {
        $db 	= JFactory::getDBO();
        $config = EasyBlogHelper::getConfig();

        $limit  = ($max == 0) ? $config->get('main_max_relatedpost', '5') : $max;

		$query	= 'select count(a.`tag_id`) as `cnt`, c.*';
		$query	.= ' from `#__easyblog_post_tag` as a';
		$query	.= '   inner join `#__easyblog_post` as c';
		$query	.= '   on a.`post_id` = c.`id`';
		$query	.= ' where a.`tag_id` in (select b.`tag_id` from `#__easyblog_post_tag` as b where b.`post_id` = ' . $db->Quote($blogId) . ')';
		$query	.= ' and a.`post_id` != ' . $db->Quote($blogId);
		$query	.= ' and c.`published` = ' . $db->Quote('1');
		$query	.= ' group by (a.`post_id`)';
		$query	.= ' order by `cnt` desc';
		$query	.= ' limit ' . $limit;

		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;
    }

    function approveBlog( $id )
    {
		$db 	= JFactory::getDBO();

		$query = 'UPDATE `#__easyblog_post` SET `ispending`= ' . $db->Quote('0') . ' WHERE `id` = ' . $db->Quote($id) . ';';
		$db->setQuery($query);

		if (!($db->query())) {
			JError::raiseError( 500, $db->stderr() );
			return false;
		}

		return true;
	}
}
