<?php
/**
 * @package     EasyBlog
 * @copyright   Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license     GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');
?>
<form name="comment-form" id="comment-form">
<ul class="item_list reset-ul">

<?php
if( $comments )
{
    $i  = 0;
?>

    <?php foreach( $comments as $comment ) { ?>
    <li id="eblog-comment-item<?php echo $comment->id; ?>">
        <div class="ui-avatar float-l">
            <?php if( $comment->created_by != 0 ) { ?>
            <?php $commenter    = EasyBlogHelper::getTable('Profile'); ?>
            <?php $commenter->load($comment->created_by); ?>
            <a href="<?php echo $commenter->getProfileLink(); ?>">
            <?php } ?>
                <img class="avatar" src="<?php echo $comment->author->getAvatar(); ?>" width="48" height="48" alt="<?php echo $comment->author->getName(); ?>" />
            <?php if( $comment->created_by != 0 ) { ?></a><?php } ?>
            <?php echo EasyBlogTooltipHelper::getBloggerHTML( $comment->created_by, array('my'=>'left bottom','at'=>'left top','of'=>array('traverseUsing'=>'prev')) ); ?>
        </div>
        <div class="ui-content">
            <div class="ui-comment-meta mbs">
                <?php
                    $blogLink       = EasyBlogRouter::_('index.php?option=com_easyblog&view=entry&id='.$comment->post_id);
                    $blogTitle      = $comment->blog_title;
                    $profileLink    = '#';
                    if( $comment->created_by != 0 )
                    {
                        $commentor      =& EasyBlogHelper::getTable( 'Profile', 'Table');
                        $commentor->load( $comment->created_by );
                        $profileLink    = $commentor->getProfileLink();
                    }

                    $submitterLink  = $profileLink;
                    $submitterName  = $comment->name;
                    $dateSubmitted  = EasyBlogDateHelper::toFormat( EasyBlogDateHelper::dateWithOffSet($comment->created) , $system->config->get('layout_dateformat', '%A, %d %B %Y') );
                    echo JText::sprintf('COM_EASYBLOG_DASHBOARD_COMMENTS_COMMENTED_ON_BLOG', '<b>' . $submitterName . '</b>', $blogLink, $blogTitle);
                ?>
            </div>
            <p class="ui-comment-content" id="comment-content-<?php echo $comment->id; ?>">
                <b class="ui-comment-title">
                <?php
                    $commentLink    = EasyBlogRouter::_('index.php?option=com_easyblog&view=entry&id=' . $comment->post_id . '#comment-' . $comment->id);
                    $commentTitle   = !empty( $comment->title ) ? $comment->title : JText::_('COM_EASYBLOG_COMMENT_NO_TITLE');
                    echo JText::sprintf('COM_EASYBLOG_DASHBOARD_COMMENTS_COMMENT_TITLE', $commentLink, $commentTitle);
                ?>
                </b>
                <?php echo $comment->comment; ?>
            </p>

            <?php if ( $comment->published == 2 ) : ?>
            <div class="ispending" id="moderate-publishing-<?php echo $comment->id;?>">
                <?php echo JText::_('COM_EASYBLOG_DASHBOARD_COMMENTS_COMMENT_UNDER_MODERATION'); ?>
                <span class="ico-publish">
                    &middot;
                    <a href="javascript:eblog.dashboard.comments.publishModerated( '<?php echo $comment->id;?>', 'publish' );" class="icon-published"><?php echo JText::_( 'COM_EASYBLOG_PUBLISHED' );?></a>
                    &middot;
                    <a href="javascript:eblog.dashboard.comments.publishModerated( '<?php echo $comment->id;?>', 'unpublish' );" class="icon-unpublished"><?php echo JText::_( 'COM_EASYBLOG_UNPUBLISHED' );?></a>
                </span>
            </div>
            <?php endif; ?>

            <ul class="ui-entry-meta clearfix reset-ul float-li mts">
                <?php if(!empty($this->acl->rules->manage_comment)) { ?>
                <li class="ico-publish" id="publishing-<?php echo $comment->id;?>">
                    <?php if($comment->published == 1) : ?>
                        <a href="javascript:eblog.dashboard.comments.publish( '<?php echo $comment->id;?>' );" class="icon-published"><?php echo JText::_( 'COM_EASYBLOG_PUBLISHED' );?></a>
                    <?php elseif($comment->published != 2) : ?>
                        <a href="javascript:eblog.dashboard.comments.publish( '<?php echo $comment->id;?>' );" class="icon-unpublished"><?php echo JText::_( 'COM_EASYBLOG_UNPUBLISHED' );?></a>
                    <?php endif; ?>
                </li>
                <?php } ?>
                <li><a href="<?php echo $blogLink.'#comment-'.$comment->id; ?>"><?php echo JText::_( 'COM_EASYBLOG_DASHBOARD_COMMENTS_COMMENT_PERMALINK');?></a></li>
            </ul>

            <?php if( !empty($this->acl->rules->edit_comment) || !empty($this->acl->rules->delete_comment) ) { ?>
            <div class="clearfix mtm">
                <div id="eblog-comment-toolbar<?php echo $comment->id; ?>" class="item_actions float-l">
                    <ul class="reset-ul float-li">
                        <?php if( !empty($this->acl->rules->edit_comment) ) : ?>
                        <li><a href="javascript:eblog.dashboard.comments.edit( '<?php echo $comment->id;?>' );"><?php echo JText::_('COM_EASYBLOG_EDIT'); ?></a></li>
                        <?php endif; ?>

                        <?php if( !empty($this->acl->rules->delete_comment) ) : ?>
                        <li><a href="javascript:eblog.dashboard.comments.remove('index.php?option=com_easyblog&view=dashboard&layout=comments','<?php echo $comment->id;?>');"><?php echo JText::_('COM_EASYBLOG_DELETE'); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="ui-date-share float-r">
                    <span class="ui-inmsg mlm"></span>
                    <span class="float-r"><?php echo $dateSubmitted;?></span>
                </div>
            </div>
            <?php } ?>

        </div>
        <?php if( $showCheckbox ){ ?>
        <span class="ui-list-select pabs"><input type="checkbox" class="stackSelect" value="<?php echo $comment->id;?>" name="cid[]" id="cb<?php echo $i;?>" /></span>
        <?php } ?>
    </li>
    <?php
        $i++;
    }
    ?>

<?php
}
else
{
?>
    <li class="no_item">
    <div class="eblog-message info">
        <?php echo JText::_('COM_EASYBLOG_DASHBOARD_COMMENTS_NO_RECENT_COMMENTS'); ?>
    </div>
    </li>
<?php
    }
?>
</ul>
</form>
<?php if( $comments && isset( $pagination ) ) : ?>
    <?php if ( $pagination->getPagesLinks() ) : ?>
    <div class="pagination"><?php echo $pagination->getPagesLinks();?></div>
    <?php endif; ?>
<?php endif; ?>
