<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */
defined('_JEXEC') or die('Restricted access');
?>
<?php if( $featured && $system->config->get( 'layout_featured' ) ) { ?>
<script type="text/javascript">
sQuery(document).ready( function(){
	eblog.featured.slider.init( 'featured-entries' , <?php echo $system->config->get( 'layout_featured_autorotate' ) == '0' ? 'false' : 'true';?> , '<?php echo $system->config->get( 'layout_featured_autorotate_interval' );?>' );
});
</script>
    <div id="ezblog-featured" class="featured-slider prel">
    	<div class="slider-holder prel">

        <ul class="featured-entries reset-ul float-li pabs">
        <?php
        $i	= 1;
    	foreach ( $featured as $row )  {
    	
          $blogger  = EasyBlogHelper::getTable('Profile', 'Table');
          $blogger->load($row->created_by);
    	?>
        	<li id="featured-wrapper-<?php echo $i;?>" class="featured-item<?php echo $i == 1 ? ' item-show' : '';?>">
        		<?php if( $row->featuredImage ) { ?>
				<div class="featured-image prel">
        			<?php echo $row->featuredImage;?>
    			</div>
    			<span class="featured-tag pabs"></span>
    			<?php } ?>

        		<div class="featured-meta<?php echo ( !$row->featuredImage ) ? ' featured-meta-full' : '';?>">
    				<h3 class="featured-title rip"><a href="<?php echo EasyBlogRouter::_( 'index.php?option=com_easyblog&view=entry&id=' . $row->id );?>"><?php echo $row->title;?></a></h3>
                        <div class="featured-content">
                    	   <?php echo JString::substr( strip_tags( $row->content ) , 0 , 250 ); ?>
                        </div>
            			<div class="featured-readmore mtm mbm">
                            <a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry&id='.$row->id); ?>"  class="featured-readmore"><span><?php echo JText::_('COM_EASYBLOG_READ_MORE'); ?></span></a>
                        </div>

                        <!--SHOWCASE AUTHOR-->
                        <div class="featured-author">
                            <?php if ( $system->config->get('layout_avatar') ) : ?>
                            <a href="<?php echo $blogger->getProfileLink(); ?>" class="float-l avatar mrm"><img src="<?php echo $row->avatar; ?>" width="35" height="35" class="avatar" /></a>
                            <?php endif; ?>
                            <div class="showcase-author">
                                <?php echo JText::_('COM_EASYBLOG_BY'); ?> <a href="<?php echo $blogger->getProfileLink(); ?>"><?php echo $row->displayName; ?></a><br />
                                <div class="small"><?php echo $this->formatDate( $system->config->get('layout_dateformat') , $row->created ); ?></div>
                            </div>
                        </div>

						<?php if( $system->config->get( 'main_ratings_frontpage' ) ) { ?>
                    	<div class="blog-rating mtm">
                        	<?php echo EasyBlogHelper::getHelper( 'ratings' )->getHTML( $row->id , EBLOG_RATINGS_TYPE_ENTRY , JText::_( 'COM_EASYBLOG_RATINGS_RATE_BLOG_ENTRY') , 'blog-' . $row->id . '-ratings' ); ?>
						</div>
						<?php } ?>
        		</div>
                <div class="clear"></div>
        	</li>
    	<?php
    		$i++;
    	}
    	?>
    	</ul>
    	</div>

        <div class="featured-navi prel">
            <a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=featured'); ?>" title="<?php echo JText::_('COM_EASYBLOG_FEATURED_VIEWMORE');?>" class="featured-more ir pabs"><?php echo JText::_('COM_EASYBLOG_FEATURED_VIEWMORE');?></a>
            <div class="featured-a">
            	<?php for( $i = 1; $i <= count( $featured ); $i++ ){ ?><a class="slider-navi-<?php echo $i;?> item<?php echo $i == 1 ? ' active' : '';?>" href="javascript:void(0);" onclick="eblog.featured.slider.slide( '<?php echo $i;?>' , 'featured-entries' );"><span><?php echo $i;?></span></a><?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
