<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');
?>
<div id="section-related" class="blog-related blog-section tab_container">
	<div class="ptl pbl">
		<ul class="reset-ul">
		<?php
			foreach($blogRelatedPost as $post) {
				$blogger	=& EasyBlogHelper::getTable( 'Profile', 'Table');
				$blogger->load( $post->created_by );
		?>
			<li id="entry_<?php echo $post->id; ?>">
				<h3 class="rip pbs"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry&id='.$post->id); ?>"><?php echo $post->title; ?></a></h3>
				<div><?php echo (JString::strlen($post->text) > 150) ? JString::substr(strip_tags($post->text), 0, 150) . '...' : strip_tags($post->text) ; ?></div>
	            <div class="small">
	        		<span><?php echo JText::sprintf('COM_EASYBLOG_BY_AUTHOR_ON', $blogger->getProfileLink(), $post->displayName); ?></span>
	        		<span class="blog-date"> - <?php echo $this->formatDate( $system->config->get('layout_shortdateformat'), $post->created ); ?></span>
	            	<span class="blog-category"><?php echo JText::sprintf('COM_EASYBLOG_IN', EasyBlogRouter::_('index.php?option=com_easyblog&view=categories&layout=listings&id='.$blog->category_id), $this->escape($blog->getCategoryName())); ?></span>
	            </div>
			</li>
		<?php } ?>
	    </ul>
    </div>
</div>
