<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die();

jimport( 'joomla.application.component.view');

class EasyBlogView extends JView
{
	function setPathway( $name , $link = '' )
	{
		static $views = null;

		require_once( EBLOG_HELPERS . DS . 'router.php' );

		$mainframe	= JFactory::getApplication();
		$pathway	= $mainframe->getPathway();

		// set this option to true if the breadcrumb didn't show the EasyBlog root menu.
		$showRootMenuItem   = false;

		if( EasyBlogHelper::getJoomlaVersion() <= '1.5' && $showRootMenuItem)
		{
			$latestPostMenuItemId   = EasyBlogRouter::getItemId('latest');

			if( !empty( $latestPostMenuItemId ) )
			{
				if( empty( $views['latest'] ) )
				{
					$menu 					=& JSite::getMenu();
					$EasyBlogMenuItem   	= $menu->getItem($latestPostMenuItemId);
					$view                   = JRequest::getCmd('view');

					if( $view != 'latest')
					{
						$frontpagelink   = JRoute::_('index.php?option=com_easyblog&view=latest&Itemid=' . $latestPostMenuItemId);
						$pathway->addItem($EasyBlogMenuItem->name, $frontpagelink);

						$views['latest']    = true;
					}
				}
			}
		}

		return $pathway->addItem( $name , $link );
	}

	function getModel( $name = null )
	{
		return EasyBlogHelper::getModel( $name );
	}

	function getView( $name , $tmpl = 'html')
	{
		static $view = array();

		if( !isset( $view[ $name ] ) )
		{
			$file	= JString::strtolower( $name );

			$path	= JPATH_ROOT . DS . 'components' . DS . 'com_easyblog' . DS . 'views' . DS . $file . DS . 'view.'. $tmpl . '.php';

			jimport('joomla.filesystem.path');
			if ( JFolder::exists( $path ))
			{
				JError::raiseWarning( 0, 'View file not found.' );
			}

			$viewClass		= 'EasyBlogView' . ucfirst( $name );

			if( !class_exists( $viewClass ) )
				require_once( $path );


			$view[ $name ] = new $viewClass();
		}

		return $view[ $name ];
	}
}
