<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

require_once( EBLOG_HELPERS . DS . 'helper.php' );
require_once( EBLOG_HELPERS . DS . 'image.php' );
require_once( EBLOG_HELPERS . DS . 'date.php' );
require_once( EBLOG_HELPERS . DS . 'comment.php' );
require_once( EBLOG_CLASSES . DS . 'adsense.php' );

class EasyBlogViewEntry extends EasyBlogView
{
	function display( $tmpl = null )
	{
		JPluginHelper::importPlugin( 'easyblog' );
		$dispatcher = JDispatcher::getInstance();
		$mainframe	= JFactory::getApplication();
		$document	= JFactory::getDocument();
		$config 	= EasyBlogHelper::getConfig();
		$my			= JFactory::getUser();
		$notice		= '';

		//for trigger
		$params		= $mainframe->getParams('com_easyblog');
		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');
		$blogId		= JRequest::getVar('id');

		if( empty($blogId) )
		{
			echo JText::_('COM_EASYBLOG_ENTRY_BLOG_NOT_FOUND');
			return;
		}

		if( $my->id <= 0 && $config->get( 'main_login_read' ) )
		{
			$mainframe->redirect( EasyBlogRouter::_( 'index.php?option=com_easyblog&view=entry&id=' . $blogId . '&layout=login' , false ) );
			$mainframe->close();
		}

		$team = JRequest::getVar('team','');

		if(empty($team))
		{
			//try get from session.
			$team	= EasyBlogHelper::getSession('EASYBLOG_TEAMBLOG_ID');

			if(! empty($team))
			{
				EasyBlogHelper::storeSession($team, 'EASYBLOG_TEAMBLOG_ID');
			}
		}
		else
		{
			EasyBlogHelper::storeSession($team, 'EASYBLOG_TEAMBLOG_ID');
		}

		// set meta tags for post
		EasyBlogHelper::setMeta( $blogId, META_TYPE_POST );

		$print = JRequest::getBool('print');

		if ($print)
		{
			$document->setMetaData( 'robots' , 'noindex, nofollow' );
		}

		$my 	= JFactory::getUser();
		$blog	= EasyBlogHelper::getTable( 'Blog', 'Table' );

		if( !$blog->load($blogId) )
		{
			echo JText::_('COM_EASYBLOG_ENTRY_BLOG_NOT_FOUND');
			return;
		}

		if( !empty( $blog->robots ) )
		{
			$document->setMetaData( 'robots' , $blog->robots );
		}

		if( !empty( $blog->copyrights ) )
		{
			$document->setMetaData( 'rights' , $blog->copyrights );
		}

		//assign the teamid here.
		$blog->team 	= $team;
		$checkIsPrivate = false;

		//check if blog is password protected.
		if($config->get('main_password_protect', true) && !empty($blog->blogpassword))
		{
			if(!EasyBlogHelper::verifyBlogPassword($blog->blogpassword, $blog->id))
			{
				$errmsg = '';

				$jSession = JFactory::getSession();
				if($jSession->has( 'PROTECTEDBLOG_'.$blog->id, 'EASYBLOG'))
				{
					$errmsg = JText::_('COM_EASYBLOG_PASSWORD_PROTECTED_BLOG_INVALID_PASSWORD');
				}

				$theme = new CodeThemes();
				$theme->set('id', $blog->id);
				$theme->set('return', base64_encode(JURI::getInstance()->toString()));
				$theme->set('errmsg', $errmsg);
				echo $theme->fetch( 'blog.protected.php' );
				return false;
			}
		}

		//if team id provided, then we need to check if the user belong to the team or not.
		if($blog->issitewide)
		{
			$checkIsPrivate = true;
		}
		else
		{
			if(empty($team))
			{
				// blog post is not sitewide and teamid is empty? this is not so right. need to check this post contributed to which team one more time.
				$team   = $blog->getTeamContributed();
				if(! empty($team))
				{
					EasyBlogHelper::storeSession($team, 'EASYBLOG_TEAMBLOG_ID');
				}
			}

			/*
			 * if teamblog access set to 'member only' | 'registered user', team blog will supersede blog permision
			 * if teamblog access set to 'everyone' then blog's permission will supersede teamblog access (logged user vs guest)
			 */

			if(! empty($team))
			{
				$teamblog	= EasyBlogHelper::getTable( 'TeamBlog', 'Table' );
				$teamblog->load($team);

				if($teamblog->access == '1')
				{
					if(! EasyBlogHelper::isTeamBlogJoined($my->id, $team))
					{
						//show error.
						EasyBlogHelper::showAccessDenied('teamblog', $teamblog->access);
						return;
					}
				}
				else if($teamblog->access == '2')
				{
					if(! EasyBlogHelper::isLoggedIn())
					{
						EasyBlogHelper::showLogin();
						return;
					}
				}
				else
				{
					// if teamblog the access set to 'everyone' then blog permission will supersede teamblog access
					$checkIsPrivate = true;
				}

			}
			else
			{
				$checkIsPrivate = true;
			}
		}

		//check if the blog permission set to private or public. if private, we
		//need to check if the user has login or not.
		if($checkIsPrivate)
		{
			$privacy	= $blog->isAccessible();

			if( !$privacy->allowed )
			{
				echo $privacy->error;
				return;
			}
		}

		//update the hits
		$blog->hit();
		$acl = EasyBlogACLHelper::getRuleSet();

		// added checking for other statuses
		switch ( $blog->published )
		{
			case 0:
				// Unpublished post
				// Only Admin and blog owner can view this post
				if ( $my->id == $blog->created_by )
				{
					$notice = JText::_('COM_EASYBLOG_ENTRY_BLOG_UNPUBLISHED_VISIBLE_TO_OWNER');
				}
				elseif ( EasyBlogHelper::isSiteAdmin() )
				{
					$notice = JText::_('COM_EASYBLOG_ENTRY_BLOG_UNPUBLISHED_VISIBLE_TO_ADMIN');
				}
				else
				{
					EasyBlogHelper::setMessageQueue( JText::_('COM_EASYBLOG_ENTRY_BLOG_NOT_FOUND') );
					$mainframe->redirect( EasyBlogRouter::_( 'index.php?option=com_easyblog&view=latest', false) );
				}
				break;

			case 2:
				// Unpublished post
				// Only Admin and blog owner can view this post
				if ( $my->id == $blog->created_by )
				{
					$notice = JText::_('COM_EASYBLOG_ENTRY_BLOG_SCHEDULED_VISIBLE_TO_OWNER');
				}
				elseif ( EasyBlogHelper::isSiteAdmin() )
				{
					$notice = JText::_('COM_EASYBLOG_ENTRY_BLOG_SCHEDULED_VISIBLE_TO_ADMIN');
				}
				else
				{
					EasyBlogHelper::setMessageQueue( JText::_('COM_EASYBLOG_ENTRY_BLOG_NOT_FOUND') );
					$mainframe->redirect( EasyBlogRouter::_( 'index.php?option=com_easyblog&view=latest', false) );
				}
				break;

			case 3:
				// Unpublished post
				// Only Admin and blog owner can view this post
				if ( $my->id == $blog->created_by )
				{
					$notice = JText::_('COM_EASYBLOG_ENTRY_BLOG_DRAFT_VISIBLE_TO_OWNER');
				}
				elseif ( EasyBlogHelper::isSiteAdmin() )
				{
					$notice = JText::_('COM_EASYBLOG_ENTRY_BLOG_DRAFT_VISIBLE_TO_ADMIN');
				}
				else
				{
					EasyBlogHelper::setMessageQueue( JText::_('COM_EASYBLOG_ENTRY_BLOG_NOT_FOUND') );
					$mainframe->redirect( EasyBlogRouter::_( 'index.php?option=com_easyblog&view=latest', false) );
				}
				break;

			case 1:
			default:
				break;
		}

		$pageTitle	= EasyBlogHelper::getPageTitle($config->get('main_title'));
		$document->setTitle( $blog->title . ' - ' . $pageTitle );

		// process the video here if nessary
		$blog->intro	= EasyBlogHelper::getHelper( 'Videos' )->processVideos( $blog->intro );
		$blog->content	= EasyBlogHelper::getHelper( 'Videos' )->processVideos( $blog->content );

		$blog->intro	= EasyBlogGoogleAdsense::processsAdsenseCode( $blog->intro, $blog->created_by );
		$blog->content	= EasyBlogGoogleAdsense::processsAdsenseCode( $blog->content, $blog->created_by );


		// @trigger: onEasyBlogPrepareContent
		EasyBlogHelper::triggerEvent( 'easyblog.prepareContent' , $blog , $params , $limitstart );


		$rawIntroText   = $blog->intro;
		// @rule: Hide introtext if necessary
		if( $config->get( 'main_hideintro_entryview' ) && !empty( $blog->content ) )
		{
			$blog->intro	= '';
		}

		//onPrepareContent trigger start
		$blog->introtext	= $blog->intro;
		$blog->text			= $blog->intro . $blog->content;

		// @trigger: onEasyBlogPrepareContent
		EasyBlogHelper::triggerEvent( 'prepareContent' , $blog , $params , $limitstart );

		$blog->intro		= $blog->introtext;
		$blog->content		= $blog->text;

		// Remove first image for featured blogs
		if( $blog->isFeatured() )
		{
			$blog->content		= EasyBlogHelper::removeFeaturedImage( $blog->content );
		}

		$isFeatured    		= EasyBlogHelper::isFeatured('post', $blog->id);

		/* Post Tags */
		$modelPT		= $this->getModel( 'PostTag' );
		$blogTags		= $modelPT->getBlogTags($blog->id);
		$arrBlogTags	= array();
		$tags			= '';

		if(! empty($blogTags))
		{
			foreach($blogTags as $bt)
			{
				$arrBlogTags[] = '<a href="' . EasyBlogRouter::_('index.php?option=com_easyblog&view=tags&layout=tag&id=' . $bt->id ) . '">' . JText::_( $bt->title ) . '</a>';
			}
			$tags	= implode(', ', $arrBlogTags);
		}
		else
		{
			$tags	= JText::_('COM_EASYBLOG_UNTAGGED');
		}

		//page setup
		$blogHtml		= '';
		$commentHtml	= '';
		$blogHeader		= '';
		$blogFooter		= '';
		$adsenseHtml	= '';
		$trackbackHtml  = '';


		$blogger	= null;
		if($blog->created_by != 0)
		{
			$blogger 	= EasyBlogHelper::getTable( 'Profile', 'Table' );
			$blogger->load( $blog->created_by );
		}

		// @rule: Before any trigger happens, try to replace the gallery first and append it at the bottom.
		$galleryHTML	= EasyBlogHelper::processGallery( $blog->content , $blog->created_by );

		$blog->intro	= EasyBlogHelper::removeGallery( $blog->intro );
		$blog->content	= EasyBlogHelper::removeGallery( $blog->content );
		$blog->content	.= $galleryHTML;


		// @rule: Process videos
		$blog->intro	= EasyBlogHelper::processVideos( $blog->intro , $blog->created_by );
		$blog->content	= EasyBlogHelper::processVideos( $blog->content , $blog->created_by );

		//onAfterDisplayTitle, onBeforeDisplayContent, onAfterDisplayContent trigger start
		$blog->event		= new stdClass();
		$blog->introtext	= $blog->intro;
		$blog->text			= $blog->content;

		// @trigger: onAfterDisplayTitle / onContentAfterTitle
		$results	= EasyBlogHelper::triggerEvent( 'afterDisplayTitle' , $blog , $params , $limitstart );
		$blog->event->afterDisplayTitle = JString::trim(implode("\n", $results));

		// @trigger: onBeforeDisplayContent / onContentBeforeDisplay
		$results	= EasyBlogHelper::triggerEvent( 'beforeDisplayContent' , $blog , $params , $limitstart );
		$blog->event->beforeDisplayContent = JString::trim(implode("\n", $results));

		// @trigger: onAfterDisplayContent / onContentAfterDisplay
		$results	= EasyBlogHelper::triggerEvent( 'afterDisplayContent' , $blog , $params , $limitstart );
		$blog->event->afterDisplayContent	= JString::trim(implode("\n", $results));

		$blog->intro		= $blog->introtext;
		$blog->content		= $blog->text;

		unset($blog->introtext);
		unset($blog->text);

		if($print)
		{
			$theme		= new CodeThemes();

			$theme->set('blog'		, $blog );
			$theme->set('tags'		, $tags );
			$theme->set('config'	, $config );
			$theme->set('blogger'	, $blogger );

			echo $theme->fetch( 'blog.read.print.php' );
			return;
		}

		if( ! EasyBlogRouter::isCurrentActiveMenu( 'blogger', $blogger->id ) && $config->get( 'layout_blogger_breadcrumb') )
		{
			$this->setPathway( $blogger->getName() , $blogger->getLink() );
		}

		if( ! EasyBlogRouter::isCurrentActiveMenu( 'entry', $blog->id ) )
			$this->setPathway( $blog->title , '' );

		$blogModel		= $this->getModel( 'Blog' );
		$theme			= new CodeThemes();

		// add checking if comment system disabled by site owner
		if ( $config->get('main_comment') )
		{
			// getting blog comments
			$commentModel		= $this->getModel( 'Comment' );
			$blogComments		= EasyBlogHelper::getHelper( 'Comment' )->getBlogComment( $blogId );
			$commtPagination	= EasyBlogHelper::getHelper( 'Comment' )->pagination;
			$comments			= array();

			if(! empty( $blogComments ) )
			{
				foreach ($blogComments as $comment)
				{
					$row 				= $comment;

					$row->comment   	= EasyBlogCommentHelper::parseBBCode($row->comment);


					if($config->get('comment_likes'))
					{
						$row->likesAuthor   = EasyBlogHelper::getLikesAuthors($row->id, 'comment', $my->id);
						$row->isLike   		= $commentModel->isLikeComment($row->id, $my->id);
					}
					else
					{
						$row->likesAuthor   = '';
						$row->isLike   		= 0;
					}
					$comments[] 	= $row;
				}
			}
			$commentHtml	= EasyBlogCommentHelper::getCommentHTML( $blog , $comments , $commtPagination );
		}
		$blog->totalComments	= EasyBlogHelper::getHelper( 'Comment' )->getCommentCount( $blogId );

		//get related blog post
		$blogRelatedPost    = '';
		if($config->get('main_relatedpost', true))
		{
			$blogRelatedPost    = $blogModel->getRelatedBlog($blogId);
			$blogRelatedPost    = EasyBlogHelper::formatBlog($blogRelatedPost);
		}

		// Facebook Like integrations
		require_once( EBLOG_CLASSES . DS . 'facebook.php' );
		$facebookLike	= EasyBlogFacebookLikes::getLikeHTML( $blog );

		$url	= EasyBlogRouter::getRoutedURL( 'index.php?option=com_easyblog&view=entry&id=' . $blog->id , false , true );

		//try to search for the 1st img in the blog
		$img            = '';
		$pattern		= '#<img[^>]*>#i';
		preg_match( $pattern , $blog->content , $matches );

		if($matches )
		{
			$img    = $matches[0];
		}
		else
		{
			$textToTest = ( $config->get( 'main_hideintro_entryview' ) ) ? $rawIntroText : $blog->intro;
			preg_match( $pattern , $textToTest , $matches );
			if($matches )
			{
				$img    = $matches[0];
			}
		}

		//image found. now we process further to get the absolute image path.

		// Default image
		$imgSrc	= rtrim( JURI::root() , '/' ) . '/components/com_easyblog/assets/images/default_facebook.png';

		if(! empty($img))
		{
			//get the img src

			$pattern = '/src=[\"\']?([^\"\']?.*(png|jpg|jpeg|gif))[\"\']?/i';
			preg_match($pattern, $img, $matches);
			if($matches)
			{
				$imgPath   = $matches[1];
				$imgSrc    = EasyImageHelper::rel2abs($imgPath, JURI::root());
			}
		}

		$document->addCustomTag( '<meta property="og:image" content="' . $imgSrc . '"/> ');

		if( $config->get('main_facebook_like') )
		{
			$document->addCustomTag( '<meta property="fb:app_id" content="' . $config->get('main_facebook_like_appid') . '"/> ');
			$document->addCustomTag( '<meta property="fb:admins" content="' . $config->get('main_facebook_like_admin') . '"/>' );
		}

		$meta	= EasyBlogHelper::getTable( 'Meta' , 'Table' );
		$meta->loadByType( META_TYPE_POST , $blog->id );
		$document->addCustomTag( '<meta property="og:title" content="' . $blog->title . '" />' );

		if( !empty( $meta->description ) )
		{
			$document->addCustomTag( '<meta property="og:description" content="' .  $meta->description . '" />' );
		}
		else
		{
			$maxContentLen  = $config->get( 'integrations_facebook_blogs_length' );
			$text			= strip_tags( $blog->content );
			if( !empty( $maxContentLen ) )
			{
				$text       = ( JString::strlen( $text ) > $maxContentLen ) ? JString::substr( $text, 0, $maxContentLen) . '...' : $text;
			}
			$document->addCustomTag( '<meta property="og:description" content="' . $text . '" />' );
		}
		$document->addCustomTag( '<meta property="og:type" content="article" />' );
		$document->addCustomTag( '<meta property="og:url" content="' . $url . '" />' );


		$prevLink	= array();
		$nextLink	= array();

		// construct prev & next link
		//get blog navigation object
		if( $config->get( 'layout_navigation') )
		{
			$blogNav    = EasyBlogHelper::getBlogNavigation($blogId, $blog->created, $team, 'team'); //$team

			$prevLink = array();
			if ( !empty($blogNav['prev'] ) )
			{
				$prevLink['id']		=  $blogNav['prev'][0]->id;
				$prevLink['title']	=  (JString::strlen($blogNav['prev'][0]->title) > 50) ? JString::substr($blogNav['prev'][0]->title, 0, 50) . '...' : $blogNav['prev'][0]->title;
			}

			$nextLink = array();
			if ( !empty($blogNav['next'] ) )
			{
				$nextLink['id']		=  $blogNav['next'][0]->id;
				$nextLink['title']	=  (JString::strlen($blogNav['next'][0]->title) > 50) ? JString::substr($blogNav['next'][0]->title, 0, 50) . '...' : $blogNav['next'][0]->title;
			}
		}


		//get social bookmark provider.
		require_once( EBLOG_CLASSES . DS . 'bookmark.php' );
		$bookmark	= EasyBlogBookmark::getHTML();


		$theme->set( 'facebookLike' 	, $facebookLike );
		$theme->set( 'notice'			, $notice );
		$theme->set( 'team'				, $team );
		$theme->set('blog'				, $blog );
		$theme->set('tags'				, $tags );
		$theme->set('blogger'			, $blogger );
		$theme->set('prevLink'			, $prevLink);
		$theme->set('nextLink'			, $nextLink);
		$theme->set('blogRelatedPost'	, $blogRelatedPost );
		$theme->set('isFeatured'		, $isFeatured );
		$theme->set('isMineBlog'		, EasyBlogHelper::isMineBlog($blog->created_by, $my->id) );
		$theme->set( 'acl'				, $acl );
		$theme->set( 'url'				, $url );
		$theme->set( 'commentHTML'		, $commentHtml );
		$theme->set( 'bookmark'			, $bookmark );
		$theme->set( 'pdfLinkProperties', EasyBlogHelper::getPDFlinkProperties() );
		$theme->set( 'ispreview', false );

		// @task: trackbacks
		$trackbacks		= $blogModel->getTrackback( $blogId );
		$theme->set( 'trackbackURL'		, EasyBlogRouter::getRoutedURL( 'index.php?option=com_easyblog&view=trackback&post_id=' . $blog->id  , true , true ) );
		$theme->set( 'trackbacks'		, $trackbacks );


		//google adsense
		$adsense	= EasyBlogGoogleAdsense::getHTML( $blogger->id );

		$blogHeader     = $adsense->header;
		$blogFooter     = $adsense->footer;

		$theme->set( 'adsenseHTML' , $adsense->beforecomments );
		$blogHtml	= $theme->fetch( 'blog.read' . EasyBlogHelper::getHelper( 'Sources' )->getTemplateFile( $blog->source ) . '.php' );

		echo $blogHeader;
		echo $blogHtml;
		echo $blogFooter;
	}

	public function login()
	{
		$theme	= new CodeThemes();
		$id		= JRequest::getInt( 'id' );

		$theme->set( 'return' , base64_encode( EasyBlogRouter::_( 'index.php?option=com_easyblog&view=entry&id=' . $id , false ) ) );
		echo $theme->fetch( 'blog.read.login.php' );
	}

	function preview()
	{
		JPluginHelper::importPlugin( 'easyblog' );
		$dispatcher = JDispatcher::getInstance();
		$mainframe	= JFactory::getApplication();
		$acl		= EasyBlogACLHelper::getRuleSet();
		$config 	= EasyBlogHelper::getConfig();
		$document	= JFactory::getDocument();
		$my			= JFactory::getUser();
		$params		= $mainframe->getParams('com_easyblog');

		if(! EasyBlogHelper::isLoggedIn())
		{
			EasyBlogHelper::showLogin();
			return;
		}

		$draftId    = JRequest::getVar( 'draftid', '');
		$draft		= EasyBlogHelper::getTable( 'Draft' , 'Table' );
		$draft->load( $draftId );


		$blog       = EasyBlogHelper::getTable( 'Blog' , 'Table' );
		$blog->bind( $draft );

		$blogId		= ( empty( $draft->entry_id ) ) ? $draft->id : $draft->entry_id;
		$limitstart = '0';
		$notice     = '';
		$team       = '';

		$blog->tags		= empty( $draft->tags ) ? array() : $this->bindTags( explode( ',' , $draft->tags ) );

		// metas
		$meta				= new stdClass();
		$meta->id			= '';
		$meta->keywords		= $draft->metakey;
		$meta->description	= $draft->metadesc;

		$pageTitle	= EasyBlogHelper::getPageTitle($config->get('main_title'));
		$document->setTitle( $blog->title . ' - ' . $pageTitle );

		// process the video here if nessary
		$blog->intro	= EasyBlogHelper::getHelper( 'Videos' )->processVideos( $blog->intro );
		$blog->content	= EasyBlogHelper::getHelper( 'Videos' )->processVideos( $blog->content );

		// @rule: Before any trigger happens, try to replace the gallery first and append it at the bottom.
		$galleryHTML	= EasyBlogHelper::processGallery( $blog->intro . $blog->content , $blog->created_by );

		$blog->intro	= EasyBlogHelper::removeGallery( $blog->intro );
		$blog->content	= EasyBlogHelper::removeGallery( $blog->content );
		$blog->content	.= $galleryHTML;

		// @trigger: onEasyBlogPrepareContent
		EasyBlogHelper::triggerEvent( 'easyblog.prepareContent' , $blog , $params , $limitstart );

		//onPrepareContent trigger start
		$blog->introtext	= $blog->intro;
		$blog->text			= $blog->intro . $blog->content;

		// @trigger: onEasyBlogPrepareContent
		EasyBlogHelper::triggerEvent( 'prepareContent' , $blog , $params , $limitstart );

		$blog->intro		= $blog->introtext;
		$blog->content		= $blog->text;

		$isFeatured    		= false;

		/* Post Tags */
		$arrBlogTags	= array();
		$tags			= '';

		if(! empty($blog->tags))
		{
			foreach($blog->tags as $bt)
			{
				$arrBlogTags[] = '<a href="javascript:void(0);">' . JText::_( $bt->title ) . '</a>';
			}
			$tags	= implode(', ', $arrBlogTags);
		}
		else
		{
			$tags	= JText::_('COM_EASYBLOG_UNTAGGED');
		}

		//page setup
		$blogHtml		= '';
		$commentHtml	= '';
		$blogHeader		= '';
		$blogFooter		= '';
		$adsenseHtml	= '';
		$trackbackHtml  = '';


		$blogger	= null;
		if($blog->created_by != 0)
		{
			$blogger 	= EasyBlogHelper::getTable( 'Profile', 'Table' );
			$blogger->load( $blog->created_by );
		}

		//onAfterDisplayTitle, onBeforeDisplayContent, onAfterDisplayContent trigger start
		$blog->event = new stdClass();

		// @trigger: onAfterDisplayTitle / onContentAfterTitle
		$results	= EasyBlogHelper::triggerEvent( 'afterDisplayTitle' , $blog , $params , $limitstart );
		$blog->event->afterDisplayTitle = JString::trim(implode("\n", $results));

		// @trigger: onBeforeDisplayContent / onContentBeforeDisplay
		$results	= EasyBlogHelper::triggerEvent( 'beforeDisplayContent' , $blog , $params , $limitstart );
		$blog->event->beforeDisplayContent = JString::trim(implode("\n", $results));

		// @trigger: onAfterDisplayContent / onContentAfterDisplay
		EasyBlogHelper::triggerEvent( 'afterDisplayContent' , $blog , $params , $limitstart );
		$blog->event->afterDisplayContent	= JString::trim(implode("\n", $results));

		if( ! EasyBlogRouter::isCurrentActiveMenu( 'blogger', $blogger->id ) )
			$this->setPathway( $blogger->getName() , $blogger->getLink() );

		if( ! EasyBlogRouter::isCurrentActiveMenu( 'entry', $blog->id ) )
			$this->setPathway( $blog->title , '' );

		$blog->totalComments	= 0;

		// Facebook Like integrations
		require_once( EBLOG_CLASSES . DS . 'facebook.php' );
		$facebookLike	= EasyBlogFacebookLikes::getLikeHTML( $blog );

		$url	= EasyBlogRouter::getRoutedURL( 'index.php?option=com_easyblog&view=entry&id=' . $blog->id , false , true );

		//get blog navigation object
		$blogNav    = EasyBlogHelper::getBlogNavigation($blog->id, $blog->created, $team, 'team'); //$team

		$prevLink = array();
		if ( !empty($blogNav['prev'] ) )
		{
			$prevLink['id']		=  $blogNav['prev'][0]->id;
			$prevLink['title']	=  (JString::strlen($blogNav['prev'][0]->title) > 50) ? JString::substr($blogNav['prev'][0]->title, 0, 50) . '...' : $blogNav['prev'][0]->title;
		}

		$nextLink = array();
		if ( !empty($blogNav['next'] ) )
		{
			$nextLink['id']		=  $blogNav['next'][0]->id;
			$nextLink['title']	=  (JString::strlen($blogNav['next'][0]->title) > 50) ? JString::substr($blogNav['next'][0]->title, 0, 50) . '...' : $blogNav['next'][0]->title;
		}

		// @rule: Hide introtext if necessary
		if( $config->get( 'main_hideintro_entryview' ) )
		{
			$blog->intro	= '';
		}

		//get social bookmark provider.
		require_once( EBLOG_CLASSES . DS . 'bookmark.php' );
		$bookmark	= EasyBlogBookmark::getHTML();


		$theme			= new CodeThemes();
		$theme->set( 'facebookLike' 	, $facebookLike );
		$theme->set( 'notice'			, $notice );
		$theme->set( 'blog'				, $blog );
		$theme->set( 'tags'				, $tags );
		$theme->set( 'blogger'			, $blogger );
		$theme->set( 'prevLink'			, $prevLink);
		$theme->set( 'nextLink'			, $nextLink);
		$theme->set( 'blogRelatedPost'	, '' );
		$theme->set( 'isFeatured'		, $isFeatured );
		$theme->set( 'isMineBlog'		, true );
		$theme->set( 'acl'				, $acl );
		$theme->set( 'url'				, $url );
		$theme->set( 'commentHTML'		, $commentHtml );
		$theme->set( 'bookmark'			, $bookmark );
		$theme->set( 'pdfLinkProperties', EasyBlogHelper::getPDFlinkProperties() );
		$theme->set( 'ispreview', true );

		// @task: trackbacks
		$trackbacks		= '';
		$theme->set( 'trackbackURL'		, EasyBlogRouter::getRoutedURL( 'index.php?option=com_easyblog&view=trackback&post_id=' . $blog->id  , true , true ) );
		$theme->set( 'trackbacks'		, $trackbacks );

		//google adsense
		require_once( EBLOG_CLASSES . DS . 'adsense.php' );
		$adsense	= EasyBlogGoogleAdsense::getHTML( $blogger->id );

		$blogHeader     = $adsense->header;
		$blogFooter     = $adsense->footer;

		$theme->set( 'adsenseHTML' , $adsense->beforecomments );
		$blogHtml	= $theme->fetch( 'blog.read.php' );

		echo $blogHeader;
		echo $blogHtml;
		echo $blogFooter;
	}

	function bindTags( $arrayData )
	{
		$result	= array();

		if( count( $arrayData ) > 0 )
		{
			foreach( $arrayData as $tag )
			{
				$obj		= new stdClass();
				$obj->title	= $tag;
				$result[]	= $obj;
			}
		}
		return $result;
	}

	function bindContribute( $contribution = '' )
	{
		if( $contribution )
		{
			$contributed			= new stdClass();
			$contributed->team_id	= $contribution;
			$contributed->selected	= 1;

			return $contributed;
		}
		return false;
	}
}
