(function($){

$.Controller(
	'EasyBlog.FileManager.Browser.ItemHandler.File',
	{
		defaults: {
			'{insertButton}': '.file-insert-button',
			'{deleteButton}': '.file-delete-button',
			'@Item': 'EasyBlog.FileManager.Browser.ItemHandler.File.Item'
		}	
	},
	function(self) { return {
		
		init: function()
		{
			self.fileManager = this.options.fileManager;

			self.render(function(html)
			{
				self.element.html(html);
			});
		},
		render: function(callback)
		{			
			$.View(
				self.template('Item'),
				self.options.properties,
				function(html)
				{
					return callback && callback.apply(self, [html]);
				}
			);
		},

		"dblclick": function()
		{
			self.quickInsertButton().click();
		},

		"{insertButton} click": function(el, event)
		{
			// Prevent showing of preview handler
			event.stopPropagation();
			
			self.insertFile();
		},

		"{deleteButton} click": function(el, event)
		{
			// Prevent showing of preview handler
			event.stopPropagation();
			
			self.deleteFile();
		},		

		insertFile: function()
		{
			var file = self.options.properties,
				title	= file.name;

			if( self.previewHandler )
			{
				title	= self.previewHandler.fileTitle().val();
			}

			var html = $('<a>').html(title).attr({'href': file.url, 'target': '_blank'}).toHTML();
						
			self.fileManager.operations.insertIntoEditor(html);
		},

		deleteFile: function()
		{
			if(confirm($.lang('COM_EASYBLOG_DELETE_FILE_CONFIRMATION')))
			{	
				self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_DELETING') + ' "' + self.options.properties.name + '"...');

				self.fileManager.operations.removeItem(self.options.properties,
				{
					success: function()
					{
						self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_DELETED') + ' "' + self.options.properties.name + '"!', 'topAndFade');

						self.fileManager.browser.removeItem(self);
					},
					error: function()
					{
						self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_ERROR_DELETING') + ' "' + self.options.properties.name + '"!', 'topAndFade');
					}
				});
			}			
		}
	}}
);

})(Foundry);