(function($){

$.Controller(
	'EasyBlog.FileManager.Browser.ItemHandler.Image',
	{
		defaults: {
			'{insertButton}': '.image-insert-button',
			'{deleteButton}': '.image-delete-button',
			'@Snippet': 'EasyBlog.FileManager.Browser.ItemHandler.Image.Snippet',
			'@Item': 'EasyBlog.FileManager.Browser.ItemHandler.Image.Item'
		}
	},
	function(self) { return {

		init: function(el, options)
		{
			self.fileManager = this.options.fileManager;

			self.render(function(html)
			{
				self.element.html(html);
			});
		},

		render: function(callback)
		{
			$.View(
				self.template('Item'),
				self.options.properties,
				function(html)
				{
					return callback && callback.apply(self, [html]);
				}
			);
		},

		insertImage: function()
		{
			var image = self.options.properties;

			var imageData =
				$(new Image()).attr(
					{
		                'src'   : image.thumbnail,
		                'title' : image.title,
		                'alt'   : image.title,
		                'width' : image.thumbwidth,
		                'height': image.thumbheight
					});

			var align = image.defaultAlignment;

			if (align==="left" || align==="right") {
				imageData.attr('align', align);
			}

			var imageElement =
				$(document.createElement('a'))
					.addClass('easyblog-thumb-preview')
					.attr({
						'href': image.fullpath,
						'title': image.title
					})
					.html(imageData);

			var imageHtml = imageElement.toHTML();

			if (align==="center") {
				imageHtml = '<p style="text-align: center;">' + imageHtml + '</p>';
			}

			self.fileManager.operations.insertIntoEditor(imageHtml);
		},

		deleteImage: function()
		{
			if (confirm($.lang('COM_EASYBLOG_DELETE_IMAGE_CONFIRMATION')))
			{
				self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_DELETING') + ' "' + self.options.properties.name + '"...');

				self.fileManager.operations.removeItem(self.options.properties,
				{
					success: function()
					{
						self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_DELETED') + ' "' + self.options.properties.name + '"!', 'topAndFade');

						self.fileManager.browser.removeItem(self);
					},
					error: function()
					{
						self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_ERROR_DELETING') + ' "' + self.options.properties.name + '"!', 'topAndFade');
					}
				});
			}
		},

		"dblclick": function()
		{
			self.insertImage();
		},

		"{insertButton} click": function(el, event)
		{
			// Prevent showing of preview handler
			event.stopPropagation();
			self.insertImage();
		},

		"{deleteButton} click": function(el, event)
		{
			event.stopPropagation();
			self.deleteImage();
		}
	}}
);

})(Foundry);
