(function($){
	
$.Controller(
	'EasyBlog.FileManager.Browser',
	{
		defaults: {

			"{contentPane}"  : '.fileManager-browser-contentPane',
			"{sidePane}"     : '.fileManager-browser-sidePane',
			"{itemGroup}"    : '.fileManager-itemGroup',
			"{itemContainer}": '.item-container',
			"{itemSeparator}": '.item-separator',
			"{contentPaneMessage}" : '.contentPane-message',
			"{previewPaneMessage}": '.previewPane-message',

			'@ItemContainer': 'EasyBlog.FileManager.Browser.ItemContainer',
			'@PreviewContainer': 'EasyBlog.FileManager.Browser.PreviewContainer'
		}
	},
	function(self) { return {

		init: function()
		{
			self.fileManager = this.options.fileManager
		},

		setLayout: function()
		{
			// Calculate & set height for image browser
			var height = self.fileManager.element.height() - self.fileManager.toolbar.element.outerHeight();

			self.element.height(height);

			if (self.currentPreviewHandler)
				self.currentPreviewHandler.setLayout();
		},

		setContentPaneMessage: function(html, position)
		{
			if (!position) position = 'top';

			switch (position)
			{
				case 'middle':
					self.contentPaneMessage()
						.html(html)
						.show()
						.position(
						{
							my: 'center center',
							at: 'center center',
							of: self.contentPane()
						});
					break;

				case 'top':
				case 'topAndFade':
					self.fileManager.toolbar.setToolbarMessage(html, position);
					break;
			}
		},

		clearContentPaneMessage: function(html)
		{
			self.contentPaneMessage()
				.empty();
			
			self.fileManager.toolbar.clearToolbarMessage();
		},

		itemHandler: {},

		getItemHandler: function(type)
		{
			return self.itemHandler[type] ||
				   ( self.itemHandler[type] = $.String.getObject('EasyBlog.FileManager.Browser.ItemHandler.' + $.String.capitalize(type)) );
		},

		previewHandler: {},

		getPreviewHandler: function(type)
		{
			return self.previewHandler[type] ||
			       ( self.previewHandler[type] = $.String.getObject('EasyBlog.FileManager.Browser.PreviewHandler.' + $.String.capitalize(type)) );
		},

		items: {},

		addItem: function(itemProp, callback)
		{
			self.createItem(itemProp, function(item)
			{
				switch(itemProp.type)
				{
					case 'upload':
						self.itemSeparator('.separator-type-upload')
							.after(item.element);
						break;
					
					case 'folder':
						var lastFolder = self.itemContainer('.item-type-folder:last');

						if (lastFolder.length > 0)
						{
							lastFolder
								.after(item.element);
						} else {
							self.itemSeparator('.separator-type-all')
								.after(item.element);
						}
						break;

					default: 
						self.itemGroup()
							.append(item.element);
						break;
				}

				self.toggleSeparators();

				return callback && callback.apply(self, [item]);
			});
		},

		createItem: function(itemProp, callback)
		{
			var itemHandler = self.getItemHandler(itemProp.type);

			$.View(
				self.template('ItemContainer'),
				{
					item: itemProp
				},
				function(html)
				{
					$(html).implement(
						itemHandler,
						{
							fileManager: self.fileManager,
							properties: itemProp
						},
						function()
						{
							var item = this;

							self.items[item.__uid] = item;

							return callback && callback.apply(self, [item]);
						}
					);
				}
			);
		},

		gotoItem: function(itemHandler)
		{
			if (itemHandler._destroyed) return;

			var scrollTop     = self.contentPane().scrollTop();
			var scrollBottom  = self.contentPane().height() + scrollTop;
			var subjectTop    = Math.floor(itemHandler.element.position().top + scrollTop);
			var subjectBottom = Math.floor(subjectTop + itemHandler.element.outerHeight(true));

			var outOfBounds = subjectTop > scrollBottom || subjectBottom < scrollTop || (subjectTop > scrollTop && subjectBottom > scrollBottom) || (subjectTop < scrollTop && subjectBottom > scrollTop);

			if (outOfBounds)
			{	
				var pageBlocker = $('<div class="page-blocker">').css({opacity: '0',position: 'fixed',top: 0,left: 0,zIndex: 10000,width : '100%',height: '100%'}).appendTo('body');

				self.contentPane()
					.scrollTo(itemHandler.element, 
					{
						duration: 500,
						onAfter: function()
						{
							pageBlocker.remove();
						}
					});
			};

			if (itemHandler.element)
				itemHandler.element.click();
		},

		removeItem: function(itemHandler)
		{
			if (itemHandler.previewHandler)
				itemHandler.previewHandler.element.remove();

			itemHandler.element.remove();

			var uid = itemHandler.__uid;

			delete self.items[itemHandler.__uid];

			self.toggleSeparators();
		},
		
		".item-container click": function(el, event)
		{
			var itemHandler = el.controller();
			self.addPreview(itemHandler);

		},

		addPreview: function(itemHandler)
		{								
			// Show existing preview handlers if they are created
			if (itemHandler.previewHandler)
			{	
				itemHandler.previewHandler
					.element.show()
					.siblings().hide();

				itemHandler.previewHandler.setLayout();
				
				self.currentPreviewHandler = itemHandler.previewHandler;

			// Create preview handlers if they are new
			} else {

				self.createPreview(itemHandler, function(previewHandler)
				{
					self.currentPreviewHandler = previewHandler;

					// Insert preview handlers into side pane
					self.sidePane()
						.append(previewHandler.element);
					
					// Hide visible preview handlers
					previewHandler.element.siblings().hide();

					// Show & set layout to this preview handler
					previewHandler.setLayout();

					// Cache the preview item
					itemHandler.previewHandler = previewHandler;
				});

			}

		},

		createPreview: function(itemHandler, callback)
		{
			var itemProp = itemHandler.options.properties;
			
			var previewHandler = self.getPreviewHandler(itemProp.type);

			$.View(
				self.template('PreviewContainer'),
				{
					item: itemProp
				},
				function(html)
				{
					$(html).implement(
						previewHandler,
						{
							fileManager: self.fileManager,
							properties: itemProp,
							itemHandler: itemHandler
						},
						function()
						{
							var preview = this;
							
							preview.itemHandler = itemHandler;

							return callback && callback.apply(self, [preview]);
						}
					);
				}
			);
		},

		toggleSeparators: function()
		{
			var hasUploadItems = self.itemContainer('.item-type-upload').length > 0;
			self.itemSeparator('.separator-type-upload').toggleClass('active', hasUploadItems);

			var hasItems = self.itemContainer(':not(.item-type-upload)').length > 0;
			self.itemSeparator('.separator-type-all').toggleClass('active', hasItems && hasUploadItems);
		},

		"{itemContainer} click": function(el)
		{
			self.itemContainer()
				.removeClass('active');

			el.addClass('active');
		},

		// Shift mode
		"{window} keydown": function(el, event)
		{
			if (event.shiftKey)
			{
				self.itemGroup().addClass('shift');				
			}
		},

		"{window} keyup": function(el, event)
		{
			self.itemGroup().removeClass('shift');
		}

	}}
);
})(Foundry);