(function($){

$.Controller(
	'EasyBlog.FileManager.Browser.PreviewHandler.File',
	{
		defaults:
		{
			'{itemPreview}': '.item-preview',
			'{itemProperties}': '.item-properties',

			'{insertButton}': '.file-insert-button',
			'{deleteButton}': '.file-delete-button',
			'{fileTitle}': '#file-title',

			'@Editor': 'EasyBlog.FileManager.Browser.PreviewHandler.File.Editor'
		}	
	},
	function(self) { return{

		init: function()
		{
			self.fileManager = self.options.fileManager;
			self.meta = self.options.properties;

			self.render(function(html)
			{
				self.element.append(html);
			});
		},

		render: function(callback)
		{
			$.View(
				self.template('Editor'),
				self.options.properties,
				function(html)
				{
					return callback && callback.apply(self, [html]);
				}
			);
		},
	
		setLayout: function()
		{
			self.itemPreview().css('height', self.element.height() - self.itemProperties().outerHeight() - (self.itemPreview().outerHeight() - self.itemPreview().height()));
		
			self.itemPreview().find('img').position({
				my: 'center',
				at: 'center',
				of: self.itemPreview()
			});
		},
		
		"{insertButton} click": function(el, event)
		{
			self.itemHandler.insertFile();
		},

		"{deleteButton} click": function(el, event)
		{
			self.itemHandler.deleteFile();
		}

	}}
);

})(Foundry);