(function($){

$.Controller(
	'EasyBlog.FileManager.Browser.PreviewHandler.Upload',
	{
		defaults: {

			'{itemProperties}': '.item-properties',
			'{itemPreview}'   : '.item-preview',

			'{uploadState}'        : '.upload-state',
			'{uploadProgress}'     : '.upload-progress',
			'{uploadProgressBar}'  : '.upload-progress-bar',
			'{uploadProgressValue}': '.upload-progress-value',

			'{uploadViewButton}': '.upload-view-button',
			'{uploadRemoveButton}': '.upload-remove-button',			

			'{uploadLog}': '.upload-log',

			'@Item': 'EasyBlog.FileManager.Browser.PreviewHandler.Upload.Item',
			'@LogItem': 'EasyBlog.FileManager.Browser.PreviewHandler.Upload.LogItem'
		}
	},
	function(self) { return {

		init: function()
		{		
			self.fileManager = self.options.fileManager;
			self.itemHandler = self.options.itemHandler;

			self.render(function(html)
			{
				self.element.append(html);

				self.setState(self.itemHandler.getState());

				self.setProgress(self.itemHandler.pseudoProgress);

				self.generateLog();
			});
		},

		render: function(callback)
		{
			$.View(
				self.template('Item'),
				self.options.properties,
				function(html)
				{
					return callback && callback.apply(self, [html]);
				}
			);
		},

		setLayout: function()
		{
			self.uploadLog()
				.css('height', self.element.height() - (self.itemPreview().outerHeight() - self.itemPreview().height()) - self.uploadState().outerHeight() - self.uploadProgress().outerHeight(true) - self.itemProperties().outerHeight());
		
			self.gotoLastLog();				
		},

		setState: function(state)
		{
			self.uploadState()
				.removeClass('state-1 state-2 state-4 state-5')
				.addClass('state-'+state);			
		},

		setProgress: function(val)
		{
			var percentage = val + '%';

			self.uploadProgressBar()
				.css('width', percentage);

			self.uploadProgressValue()
				.html(percentage);
		},

		lastLog: -1,

		regenerateLog: false,

		generatingLog: false,

		generateLog: function()
		{
			if (self.generatingLog)
			{
				self.regenerateLog = true;
				return;
			}

			self.generatingLog = true;

			self.regenerateLog = false;

			var logs = self.itemHandler.history;

			for (var i=self.lastLog+1; i<logs.length; i++)
			{
				var log = logs[i];

				// Need to use a proper date API in the future
				var pad = function(n) { return ((n.toString().length==1) ? '0' : '') + n; };

				// Build timestamp
				var timestamp = pad(log.timestamp.getHours()) + ':' + pad(log.timestamp.getMinutes()) + ':' + pad(log.timestamp.getSeconds());

				$.View(
					self.template('LogItem'),
					{
						timestamp: timestamp,
						message: log.message
					},
					function(html)
					{
						self.uploadLog()
							.append(html);
					}
				);

				self.lastLog = i;
			}

			self.gotoLastLog();

			self.generatingLog = false;

			if (self.regenerateLog) self.generateLog();			
		},

		gotoLastLog: function()
		{
			self.uploadLog().scrollTop( self.uploadLog()[0].scrollHeight );
		},

		"{uploadViewButton} click": function(el, event)
		{
			event.stopPropagation();

			self.fileManager.browser.gotoItem(self.itemHandler.fileItemHandler);
		},		

		"{uploadRemoveButton} click": function(el, event)
		{
			event.stopPropagation();

			var id = self.options.properties.id;

			self.fileManager.uploader.remove(id);
		}		

	}}
);
})(Foundry);