window.Foundry = window.$ = sQuery;

(function($)
{
	$.fn.toHTML = function()
	{
		return $('<div>').html(this).html();
	}

	$.fn.implement = function(controllerName, options, callback)
	{
	    var elements = this;

	    var controller = (typeof(controllerName)=="string") ? $.String.getObject(controllerName) : controllerName;

	    $.each(elements, function(){
	        var instance = new controller(this, options);
	        callback && callback.apply(instance);
	    });

	    return this;
	}


	var $lang = {};  // Private language object (supposedly)

	$.lang = function(name)
	{
		if ($.isPlainObject(name))
		{
			$.extend($lang, name);
			return name;
		}

		if (typeof name == 'string')
		{
			return $lang[name] || name;
		}
	}

})(Foundry);
