<?php
/**
 * 	Copyright 2011
 *  This file is part of JGooMap.
 *
 *  JGooMap is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  JGooMap is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with JGooMap.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Created on Aug 14, 2008
 * @author James Hansen(Kermode Bear Software)
 *
 */

jimport('joomla.event.plugin');

class plgButtoniGooMap extends JPlugin
{
	function plgButtoniGooMap(& $subject, $config) {
		parent::__construct($subject, $config);
	}

	/**
	 * Fix for Joomla 1.5.14+ and TinyMCE 3.2.4.1+. Inserted script tags into the
	 * content editor is added with the following: mce:, mce-, mce_.
	 */
	function unfillterTinyMCE(){
		$config =& JFactory::getConfig();
		$debug = $config->getValue('config.debug');
		$editor = JFactory::getEditor()->_name;
		if($editor != 'tinymce') return;

		$file = JURI::root() . 'plugins/editors-xtd/igoomap/js/filtertinyMCE.js';
		$doc = JFactory::getDocument();
		$doc->addScript($file);
	}

 	function onDisplay($name){
		global $mainframe;

		JPlugin::loadLanguage('plg_editors-xtd_igoomap', JPATH_ADMINISTRATOR);

		$plugin =&  JPluginHelper::getPlugin( 'editors-xtd', 'iGooMap' );

        $params =& new JParameter( $plugin->params );

		$doc =& JFactory::getDocument();
		$button = new JObject();

		$style = ".button2-left .JGooMap{
					background:transparent url(" . JURI::root() . "plugins/editors-xtd/igoomap/j_button2_igoomap.png) no-repeat scroll 100% 0pt;
					}";

		$doc->addStyleDeclaration($style);

		// Title and name of the button.
		$button->set('text', JText::_('Insert Google Maps'));

		// Name of the button.
		$button->set('name', 'JGooMap');

		$link = '';
		$this->unfillterTinyMCE();
		$editor = JFactory::getEditor();
		$zoom = $params->get('zoom', 13);
		$lat = $params->get('lat' , 37.44);
		$lng = $params->get('lng', -122.1419);
	
		$link = $this->createEditorLink( $lat , $lng, $zoom );
		$link .= '&editor=' . $name;

		if($params->get('display', 'window') == 'window'){
			// Opening the JGooMap in a window.
			$button->set('modal',false);
			$button->set('onclick', 'window.open(\'' . $link . '\', \'jGooMap\', \'width=825,height=450,scrollbars=yes\'); return false;' );
			$button->set('link', '#');
		}else{ // Display in a modal Iframe.
			$button->set('modal',true);
			$button->set('link', $link);	
			// if 'modal' is true use the following line to setup an modal box.
			$options = "{handler: 'iframe', size: {x: 840, y: 430} }";
			$button->set('options', $options);
 		}

	 	return $button;
	}

	/**
	 * Create the link for the Editor button
	 */
	function createEditorLink($lat, $lng, $zoom) {
		global $mainframe;

		$link = '';
		$config =& JFactory::getConfig();
		$debug = $config->getValue('config.debug');

		$jEditor = JFactory::getEditor();
		$editor = $jEditor->_name;

		if($debug){
			error_log("Editor: $editor");
		}

		if($mainframe->isAdmin()){
			$link =  '../plugins/editors-xtd/igoomap/gmaptool.php?';
		}else{
			$link =  'plugins/editors-xtd/igoomap/gmaptool.php?';
		}

		$link .= 'lat=' .$lat . '&lng='.$lng . '&zoom='.$zoom;

		if($debug){
			$link .= '&debug=true';
		}
		
		return $link;
	}
	
	function createMarkerList(){
		$dir = 'plugins/editors-xtd/igoomap/images/library/';
		$extensions =  "bmp|gif|jpg|png";
		$name = 'markerImage';
		$javascript = false;
		
		if ( !$javascript ) {
			$javascript = "onchange=\"javascript:if (document.forms.adminForm." . $name . ".options[selectedIndex].value!='') {document.imagelib.src='..$dir' + document.forms.adminForm." . $name . ".options[selectedIndex].value} else {document.imagelib.src='../images/blank.png'}\"";
		}

		jimport( 'joomla.filesystem.folder' );
		$imageFiles = JFolder::files( JPATH_SITE.DS.$dir );
		$images 	= array(  JHTML::_('select.option',  '', '- '. JText::_( 'Select Image' ) .' -' ) );
		foreach ( $imageFiles as $file ) {
		   if ( eregi( $extensions, $file ) ) {
				$images[] = JHTML::_('select.option',  $file );
			}
		}
		echo JHTML::_('select.genericlist',  $images, 'markerImage' , 'class="inputbox" style="display:none;" size="1" '. $javascript, 'value', 'text', null );

	}
}
?>